/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.io.IOException;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpIOException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Element;

public class DbgpDebuggingEngineCommunicator
implements IDbgpCommunicator {
    private final IDbgpDebugingEngine engine;

    private void sendRequest(String command) throws IOException {
        this.engine.sendCommand(command);
    }

    private DbgpResponsePacket receiveResponse(int transactionId) throws IOException, InterruptedException {
        return this.engine.getResponsePacket(transactionId);
    }

    public DbgpDebuggingEngineCommunicator(IDbgpDebugingEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    public Element communicate(DbgpRequest request) throws DbgpException {
        try {
            this.sendRequest(request.toString());
            Element response = this.receiveResponse(Integer.parseInt(request.getOption("-i"))).getContent();
            DbgpDebuggingEngineException e = DbgpXmlParser.checkError(response);
            if (e != null) {
                throw e;
            }
            return response;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    public void send(DbgpRequest request) throws DbgpException {
        try {
            this.sendRequest(request.toString());
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }
}

