/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.launcher;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.debug.ui.launchConfigurations.CommonScriptLaunchTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchMessages;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WorkingDirectoryBlock
extends CommonScriptLaunchTab {
    private Button fWorkspaceButton;
    private Button fFileSystemButton;
    private Button fVariablesButton;
    private Button fUseDefaultDirButton = null;
    private Button fUseOtherDirButton = null;
    private Text fOtherWorkingText = null;
    private Text fWorkingDirText;
    private ILaunchConfiguration fLaunchConfiguration;
    private WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout workingDirLayout = new GridLayout();
        workingDirLayout.numColumns = 2;
        workingDirLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)workingDirLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        this.setControl((Control)group);
        group.setText(DLTKLaunchMessages.WorkingDirectoryBlock_12);
        this.fUseDefaultDirButton = new Button((Composite)group, 16);
        this.fUseDefaultDirButton.setText(DLTKLaunchMessages.WorkingDirectoryBlock_18);
        this.fUseDefaultDirButton.setFont(font);
        this.fUseDefaultDirButton.addSelectionListener((SelectionListener)this.fListener);
        this.fWorkingDirText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fWorkingDirText.setLayoutData((Object)gd);
        this.fWorkingDirText.setFont(font);
        this.fWorkingDirText.addModifyListener((ModifyListener)this.fListener);
        this.fWorkingDirText.setEnabled(false);
        this.fUseOtherDirButton = new Button((Composite)group, 16);
        this.fUseOtherDirButton.setText(DLTKLaunchMessages.WorkingDirectoryBlock_19);
        this.fUseOtherDirButton.setFont(font);
        this.fUseOtherDirButton.addSelectionListener((SelectionListener)this.fListener);
        this.fOtherWorkingText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fOtherWorkingText.setLayoutData((Object)gd);
        this.fOtherWorkingText.setFont(font);
        this.fOtherWorkingText.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(128);
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(font);
        this.fWorkspaceButton = this.createPushButton(buttonComp, DLTKLaunchMessages.WorkingDirectoryBlock_0, null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, DLTKLaunchMessages.WorkingDirectoryBlock_1, null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fVariablesButton = this.createPushButton(buttonComp, DLTKLaunchMessages.WorkingDirectoryBlock_17, null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void dispose() {
    }

    private void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(DLTKLaunchMessages.WorkingDirectoryBlock_7);
        String currentWorkingDir = this.getWorkingDirectoryText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fOtherWorkingText.setText(selectedDirectory);
        }
    }

    private void handleWorkspaceDirBrowseButtonSelected() {
        IContainer currentContainer = this.getContainer();
        if (currentContainer == null) {
            currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, DLTKLaunchMessages.WorkingDirectoryBlock_4);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.setOtherWorkingDirectoryText("${workspace_loc:" + containerName + "}");
        }
    }

    protected IContainer getContainer() {
        String path = this.getWorkingDirectoryText();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IContainer[] containers = root.findContainersForLocation((IPath)new Path(path));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return null;
    }

    private void handleUseDefaultWorkingDirButtonSelected() {
        this.fWorkspaceButton.setEnabled(false);
        this.fOtherWorkingText.setEnabled(false);
        this.fVariablesButton.setEnabled(false);
        this.fFileSystemButton.setEnabled(false);
        this.fUseOtherDirButton.setSelection(false);
    }

    private void handleUseOtherWorkingDirButtonSelected() {
        this.fOtherWorkingText.setEnabled(true);
        this.fWorkspaceButton.setEnabled(true);
        this.fVariablesButton.setEnabled(true);
        this.fFileSystemButton.setEnabled(true);
        this.updateLaunchConfigurationDialog();
    }

    private void handleWorkingDirVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variableText = dialog.getVariableExpression();
        if (variableText != null) {
            this.fOtherWorkingText.insert(variableText);
        }
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void setDefaultWorkingDir() {
        try {
            IScriptProject project;
            String projectName;
            ILaunchConfiguration config = this.getLaunchConfiguration();
            if (config != null && !(projectName = config.getAttribute("project", "")).equals("") && (project = DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getScriptProject(projectName)) != null) {
                this.setDefaultWorkingDirectoryText("${workspace_loc:" + project.getPath().makeRelative().toOSString() + "}");
                return;
            }
        }
        catch (CoreException coreException) {}
        this.setDefaultWorkingDirectoryText(System.getProperty("user.dir"));
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.getWorkingDirectoryText();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else if (workingDirPath.length() > 0) {
            IContainer container = this.getContainer();
            if (container == null) {
                File dir = new File(workingDirPath);
                if (dir.isDirectory()) {
                    return true;
                }
                this.setErrorMessage(DLTKLaunchMessages.WorkingDirectoryBlock_10);
                return false;
            }
        } else if (workingDirPath.length() == 0) {
            this.setErrorMessage(DLTKLaunchMessages.WorkingDirectoryBlock_20);
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("workingDir", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("workingDir", null);
            this.setDefaultWorkingDir();
            if (wd != null) {
                this.setOtherWorkingDirectoryText(wd);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(DLTKLaunchMessages.ArgumentsTab_Exception_occurred_reading_configuration___15) + e.getStatus().getMessage());
            DLTKLaunchingPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fUseDefaultDirButton.getSelection()) {
            configuration.setAttribute("workingDir", null);
        } else {
            configuration.setAttribute("workingDir", this.getWorkingDirectoryText());
        }
    }

    public String getName() {
        return DLTKLaunchMessages.WorkingDirectoryBlock_Working_Directory_8;
    }

    protected String getWorkingDirectoryText() {
        if (this.fUseDefaultDirButton.getSelection()) {
            return this.fWorkingDirText.getText().trim();
        }
        return this.fOtherWorkingText.getText().trim();
    }

    protected void setDefaultWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fWorkingDirText.setText(dir);
            this.fUseDefaultDirButton.setSelection(true);
            this.handleUseDefaultWorkingDirButtonSelected();
        }
    }

    protected void setOtherWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fOtherWorkingText.setText(dir);
            this.fUseDefaultDirButton.setSelection(false);
            this.fUseOtherDirButton.setSelection(true);
            this.handleUseOtherWorkingDirButtonSelected();
        }
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setEnabled(boolean enabled) {
        this.fUseDefaultDirButton.setEnabled(enabled);
        this.fUseOtherDirButton.setEnabled(enabled);
        if (this.fOtherWorkingText.isEnabled()) {
            this.fOtherWorkingText.setEnabled(enabled);
            this.fWorkspaceButton.setEnabled(enabled);
            this.fVariablesButton.setEnabled(enabled);
            this.fFileSystemButton.setEnabled(enabled);
        }
        if (this.fUseOtherDirButton.getSelection() && enabled) {
            this.fOtherWorkingText.setEnabled(enabled);
        }
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.fWorkspaceButton) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fFileSystemButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fVariablesButton) {
                WorkingDirectoryBlock.this.handleWorkingDirVariablesButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fUseDefaultDirButton) {
                if (WorkingDirectoryBlock.this.fUseDefaultDirButton.getSelection()) {
                    WorkingDirectoryBlock.this.setDefaultWorkingDir();
                }
            } else if (source == WorkingDirectoryBlock.this.fUseOtherDirButton && WorkingDirectoryBlock.this.fUseOtherDirButton.getSelection()) {
                WorkingDirectoryBlock.this.handleUseOtherWorkingDirButtonSelected();
            }
        }
    }
}

