/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public final class TclPairMatcher
implements ICharacterPairMatcher {
    private IDocument fDocument;
    private int fOffset;
    private int fStartPos;
    private int fEndPos;
    private int fAnchor;
    private PairBlock[] cachedPairs;
    private long cachedStamp = -1L;
    private long cachedHash = -1L;

    public TclPairMatcher(char[] pairs) {
    }

    private PairBlock[] computePairRanges(int offset, String contents) {
        ISourceParser pp = null;
        try {
            pp = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
        }
        catch (CoreException e1) {
            if (DLTKCore.DEBUG) {
                e1.printStackTrace();
            }
            return new PairBlock[0];
        }
        ModuleDeclaration md = pp.parse(null, contents.toCharArray(), null);
        if (md == null) {
            return new PairBlock[0];
        }
        List statements = md.getStatements();
        if (statements == null) {
            return new PairBlock[0];
        }
        ArrayList<PairBlock> result = new ArrayList<PairBlock>();
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            Statement sst = (Statement)i.next();
            if (!(sst instanceof TclStatement)) continue;
            TclStatement statement = (TclStatement)sst;
            Iterator si = statement.getExpressions().iterator();
            while (si.hasNext()) {
                TclBlockExpression be;
                Expression ex = (Expression)si.next();
                if (ex instanceof TclBlockExpression) {
                    be = (TclBlockExpression)ex;
                    try {
                        String newContents = contents.substring(be.sourceStart() + 1, be.sourceEnd() - 1);
                        result.add(new PairBlock(offset + be.sourceStart(), offset + be.sourceEnd() - 1, '{'));
                        PairBlock[] cb = this.computePairRanges(offset + be.sourceStart() + 1, newContents);
                        int j = 0;
                        while (j < cb.length) {
                            result.add(cb[j]);
                            ++j;
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    continue;
                }
                if (ex instanceof StringLiteral) {
                    be = (StringLiteral)ex;
                    result.add(new PairBlock(offset + be.sourceStart(), offset + be.sourceEnd() - 1, '\"'));
                    continue;
                }
                if (!(ex instanceof TclExecuteExpression)) continue;
                be = (TclExecuteExpression)ex;
                result.add(new PairBlock(offset + be.sourceStart(), offset + be.sourceEnd() - 1, '['));
            }
        }
        return result.toArray(new PairBlock[result.size()]);
    }

    private void recalc() throws BadLocationException {
        String content = this.fDocument.get(0, this.fDocument.getLength());
        this.cachedPairs = this.computePairRanges(0, content);
        if (this.fDocument instanceof IDocumentExtension4) {
            this.cachedStamp = ((IDocumentExtension4)this.fDocument).getModificationStamp();
        } else {
            this.cachedHash = content.hashCode();
        }
    }

    private void updatePairs() throws BadLocationException {
        String content;
        IDocumentExtension4 document;
        if (this.fDocument instanceof IDocumentExtension4 ? (document = (IDocumentExtension4)this.fDocument).getModificationStamp() == this.cachedStamp : (long)(content = this.fDocument.get(0, this.fDocument.getLength())).hashCode() == this.cachedHash) {
            return;
        }
        this.recalc();
    }

    private static boolean isBrace(char c) {
        return c == '{' || c == '}' || c == '\"' || c == '[' || c == ']';
    }

    public IRegion match(IDocument document, int offset) {
        block6: {
            block5: {
                if (document == null || offset < 0) {
                    throw new IllegalArgumentException();
                }
                this.fOffset = offset;
                this.fDocument = document;
                if (TclPairMatcher.isBrace(this.fDocument.getChar(offset)) || offset != 0 && TclPairMatcher.isBrace(this.fDocument.getChar(offset - 1))) break block5;
                return null;
            }
            try {
                this.updatePairs();
                if (this.matchPairsAt() && this.fStartPos != this.fEndPos) {
                    return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG_PARSER) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    private boolean matchPairsAt() {
        this.fStartPos = -1;
        this.fEndPos = -1;
        int i = 0;
        while (i < this.cachedPairs.length) {
            PairBlock block = this.cachedPairs[i];
            if (this.fOffset == block.end + 1) {
                this.fStartPos = block.start - 1;
                this.fEndPos = block.start;
                this.fAnchor = 1;
                return true;
            }
            if (this.fOffset == block.start + 1) {
                this.fStartPos = block.end - 1;
                this.fEndPos = block.end;
                this.fAnchor = 1;
                return true;
            }
            ++i;
        }
        return false;
    }

    private class PairBlock {
        int start;
        int end;
        char c;

        public PairBlock(int start, int end, char c) {
            this.start = start;
            this.end = end;
            this.c = c;
        }
    }
}

