/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.internal.parser.visitors.RubyAttributeHandler;

public class RubySourceElementRequestor
extends SourceElementRequestVisitor {
    private static final String NEW_CALL = "new";
    private static final String ATTR = "attr";
    private static final String VALUE = "value";
    private static final String ATTR_ACCESSOR = "attr_accessor";
    private static final String ATTR_WRITER = "attr_writer";
    private static final String ATTR_READER = "attr_reader";
    private List fNotAddedFields = new ArrayList();
    private Map fTypeVariables = new HashMap();

    private boolean canAddVariables(ASTNode type, String name) {
        if (this.fTypeVariables.containsKey(type)) {
            List variables = (List)this.fTypeVariables.get(type);
            if (variables.contains(name)) {
                return false;
            }
            variables.add(name);
            return true;
        }
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(name);
        this.fTypeVariables.put(type, variables);
        return true;
    }

    private void addVariableReference(ASTNode left, ASTNode right, boolean inClass, boolean inMethod) {
        if (left == null) {
            throw new IllegalArgumentException("addVariable expression can't be null");
        }
        if (left instanceof VariableReference) {
            VariableReference var = (VariableReference)left;
            if (!inMethod && this.canAddVariables((ASTNode)this.fNodes.peek(), var.getName())) {
                ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
                info.modifiers = 128;
                info.name = var.getName();
                info.nameSourceEnd = var.sourceEnd() - 1;
                info.nameSourceStart = var.sourceStart();
                info.declarationStart = var.sourceStart();
                this.fRequestor.enterField(info);
                if (right != null) {
                    this.fRequestor.exitField(right.sourceEnd() - 1);
                } else {
                    this.fRequestor.exitField(var.sourceEnd() - 1);
                }
            }
        }
    }

    protected String[] processSuperClasses(TypeDeclaration type) {
        ASTListNode list = type.getSuperClasses();
        if (list == null) {
            return new String[0];
        }
        List expressions = list.getChilds();
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            ASTNode expr = (ASTNode)iter.next();
            if (expr instanceof SimpleReference) {
                names.add(((SimpleReference)expr).getName());
                continue;
            }
            if (!(expr instanceof RubyColonExpression)) continue;
            String name = "";
            while (expr instanceof RubyColonExpression) {
                RubyColonExpression colonExpression = (RubyColonExpression)expr;
                name = "::" + colonExpression.getName();
                ASTNode left = colonExpression.getLeft();
                if (!colonExpression.isFull() && left == null) {
                    name = name.substring(2);
                }
                expr = left;
            }
            if (expr instanceof ConstantReference) {
                ConstantReference constant = (ConstantReference)expr;
                name = String.valueOf(constant.getName()) + name;
            }
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    protected String makeLanguageDependentValue(ASTNode value) {
        String outValue = "";
        return outValue;
    }

    public RubySourceElementRequestor(ISourceElementRequestor requestor) {
        super(requestor);
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
        if (DLTKCore.DEBUG) {
            System.out.println("==> Method: " + method.getName());
        }
        Iterator it = this.fNotAddedFields.iterator();
        while (it.hasNext()) {
            TypeField field = (TypeField)it.next();
            if (!this.canAddVariables(field.getASTNode(), field.getName())) continue;
            PositionInformation pos = field.getPosition();
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            info.modifiers = 128;
            info.name = field.getName();
            info.nameSourceEnd = pos.nameEnd - 1;
            info.nameSourceStart = pos.nameStart;
            info.declarationStart = pos.sourceStart;
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(pos.sourceEnd);
        }
        this.fNotAddedFields.clear();
    }

    protected static boolean isAttrLike(String name) {
        return name.equals(ATTR_READER) || name.equals(ATTR_WRITER) || name.equals(ATTR_ACCESSOR) || name.equals(ATTR);
    }

    public boolean visit(ASTNode expression) throws Exception {
        RubyAliasExpression alias;
        String oldValue;
        if (DLTKCore.DEBUG) {
            System.out.println("==> Expression: " + expression.toString());
        }
        if (expression instanceof RubyAssignment) {
            RubyAssignment assignment = (RubyAssignment)expression;
            ASTNode left = assignment.getLeft();
            ASTNode right = assignment.getRight();
            this.addVariableReference(left, right, this.fInClass, this.fInMethod);
        } else if (expression instanceof CallExpression) {
            ASTNode receiver;
            int end;
            int start;
            CallExpression callExpression = (CallExpression)expression;
            String name = callExpression.getName();
            if (RubyAttributeHandler.isAttributeCreationCall(callExpression)) {
                RubyAttributeHandler info = new RubyAttributeHandler(callExpression);
                List readers = info.getReaders();
                Iterator iterator = readers.iterator();
                while (iterator.hasNext()) {
                    ASTNode n = (ASTNode)iterator.next();
                    String attr = RubyAttributeHandler.getText(n);
                    ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
                    mi.name = attr;
                    mi.modifiers = 131072;
                    mi.nameSourceStart = n.sourceStart();
                    mi.nameSourceEnd = n.sourceEnd() - 1;
                    mi.declarationStart = n.sourceStart();
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(n.sourceEnd());
                }
                List writers = info.getWriters();
                Iterator iterator2 = writers.iterator();
                while (iterator2.hasNext()) {
                    ASTNode n = (ASTNode)iterator2.next();
                    String attr = RubyAttributeHandler.getText(n);
                    ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
                    mi.parameterNames = new String[]{VALUE};
                    mi.name = String.valueOf(attr) + "=";
                    mi.modifiers = 131072;
                    mi.nameSourceStart = n.sourceStart();
                    mi.nameSourceEnd = n.sourceEnd() - 1;
                    mi.declarationStart = n.sourceStart();
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(n.sourceEnd());
                }
            }
            name.equals("require");
            int argsCount = 0;
            CallArgumentsList args = callExpression.getArgs();
            if (args != null && args.getChilds() != null) {
                argsCount = args.getChilds().size();
            }
            if ((start = callExpression.sourceStart()) < 0) {
                start = 0;
            }
            if ((end = callExpression.sourceEnd()) < 0) {
                end = 1;
            }
            this.fRequestor.acceptMethodReference(callExpression.getName().toCharArray(), argsCount, start, end);
            if (callExpression.getName().equals(NEW_CALL) && (receiver = callExpression.getReceiver()) instanceof ConstantReference) {
                this.fRequestor.acceptTypeReference(((ConstantReference)receiver).getName().toCharArray(), receiver.sourceStart());
            }
        } else if (expression instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)expression;
            int pos = variableReference.sourceStart();
            if (pos < 0) {
                pos = 0;
            }
            this.fRequestor.acceptFieldReference(variableReference.getName().toCharArray(), pos);
        } else if (expression instanceof RubyConstantDeclaration) {
            RubyConstantDeclaration constant = (RubyConstantDeclaration)expression;
            SimpleReference constName = constant.getName();
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            info.modifiers = 2;
            info.name = constName.getName();
            info.nameSourceEnd = constName.sourceEnd() - 1;
            info.nameSourceStart = constName.sourceStart();
            info.declarationStart = constName.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(constName.sourceEnd() - 1);
        } else if (expression instanceof RubyAliasExpression && !(oldValue = (alias = (RubyAliasExpression)expression).getOldValue()).startsWith("$")) {
            String newValue = alias.getNewValue();
            ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
            mi.name = newValue;
            mi.modifiers = 262144;
            mi.nameSourceStart = alias.sourceStart();
            mi.nameSourceEnd = alias.sourceEnd() - 1;
            mi.declarationStart = alias.sourceStart();
            mi.parameterNames = new String[]{oldValue};
            this.fRequestor.enterMethod(mi);
            this.fRequestor.exitMethod(alias.sourceEnd());
        }
        return true;
    }

    public boolean endvisit(ASTNode expression) throws Exception {
        return true;
    }

    public boolean visit(Expression expression) throws Exception {
        super.visit(expression);
        return this.visit((ASTNode)expression);
    }

    public boolean visit(Statement statement) throws Exception {
        super.visit(statement);
        return this.visit((ASTNode)statement);
    }

    private static class TypeField {
        private String fName;
        private String fInitValue;
        private PositionInformation fPos;
        private ASTNode fExpression;
        private ASTNode fToNode;

        public TypeField(String name, String initValue, PositionInformation pos, ASTNode expression, ASTNode toNode) {
            this.fName = name;
            this.fInitValue = initValue;
            this.fPos = pos;
            this.fExpression = expression;
            this.fToNode = toNode;
        }

        public String getName() {
            return this.fName;
        }

        public String getInitValue() {
            return this.fInitValue;
        }

        public PositionInformation getPosition() {
            return this.fPos;
        }

        public ASTNode getExpression() {
            return this.fExpression;
        }

        public ASTNode getASTNode() {
            return this.fToNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeField) {
                TypeField typeFileld = (TypeField)obj;
                return typeFileld.fName.equals(this.fName) && typeFileld.fToNode.equals(this.fToNode);
            }
            return false;
        }

        public String toString() {
            return this.fName;
        }
    }
}

