/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.mixin.IMixinParser;

public class MixinManager {
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.core.mixin";
    private static final String NATURE_ATTR = "nature";
    private static Map parsers;

    private static void initialize() {
        if (parsers != null) {
            return;
        }
        parsers = new HashMap(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTPOINT);
        int i = 0;
        while (i < cfg.length) {
            String nature = cfg[i].getAttribute(NATURE_ATTR);
            if (parsers.get(nature) != null) {
                System.err.println("TODO log redeclaration");
            }
            parsers.put(nature, cfg[i]);
            ++i;
        }
    }

    private static String findScriptNature(IProject project) throws CoreException {
        MixinManager.initialize();
        String[] natureIds = project.getDescription().getNatureIds();
        int i = 0;
        while (i < natureIds.length) {
            String natureId = natureIds[i];
            if (parsers.containsKey(natureId)) {
                return natureId;
            }
            ++i;
        }
        return null;
    }

    public static IMixinParser getMixinParser(String natureId) throws CoreException {
        MixinManager.initialize();
        Object ext = parsers.get(natureId);
        if (ext != null) {
            if (ext instanceof IMixinParser) {
                return (IMixinParser)ext;
            }
            IConfigurationElement cfg = (IConfigurationElement)ext;
            IMixinParser toolkit = (IMixinParser)cfg.createExecutableExtension("class");
            parsers.put(natureId, toolkit);
            return toolkit;
        }
        return null;
    }

    public static IMixinParser getMixinParser(IModelElement element) throws CoreException {
        IMixinParser toolkit;
        IProject project = element.getScriptProject().getProject();
        String natureId = MixinManager.findScriptNature(project);
        if (natureId != null && (toolkit = MixinManager.getMixinParser(natureId)) != null) {
            return toolkit;
        }
        return null;
    }
}

