/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.PackageDeclaration;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.internal.core.SourceModuleStructureRequestor;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.utils.CorePrinter;

public class BuiltinSourceModule
extends Openable
implements IExternalSourceModule,
IStorage,
ISourceModule {
    private static final boolean DEBUG_PRINT_MODEL = DLTKCore.DEBUG_PRINT_MODEL;
    protected String name;
    public WorkingCopyOwner owner;
    private final boolean fReadOnly;
    static /* synthetic */ Class class$0;

    public BuiltinSourceModule(BuiltinScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent);
        this.name = name;
        this.owner = owner;
        this.fReadOnly = true;
    }

    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        throw new ModelException(new ModelStatus(967, this));
    }

    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        if (!this.isPrimary()) {
            throw this.newNotPresentException();
        }
        SourceModuleElementInfo moduleInfo = (SourceModuleElementInfo)info;
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            buffer = this.openBuffer(pm, moduleInfo);
        }
        char[] contents = buffer == null ? null : buffer.getCharacters();
        try {
            SourceModuleStructureRequestor requestor = new SourceModuleStructureRequestor(this, moduleInfo, newElements);
            IDLTKLanguageToolkit toolkit = null;
            toolkit = DLTKLanguageManager.getLanguageToolkit(this.getScriptProject());
            if (toolkit == null) {
                throw new ModelException(new ModelStatus(983));
            }
            ISourceElementParser parser = DLTKLanguageManager.getSourceElementParser(toolkit.getNatureId());
            parser.setRequestor(requestor);
            ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
            ISourceModuleInfoCache.ISourceModuleInfo mifo = sourceModuleInfoCache.get(this);
            parser.parseSourceModule(contents, mifo, this.getPath().toString().toCharArray());
            if (DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter(System.out);
                this.printNode(printer);
                printer.flush();
            }
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected Object createElementInfo() {
        return new SourceModuleElementInfo();
    }

    public int getElementType() {
        return 5;
    }

    public IResource getResource() {
        return null;
    }

    public IPath getPath() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    public ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return null;
    }

    public void discardWorkingCopy() throws ModelException {
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuiltinSourceModule)) {
            return false;
        }
        BuiltinSourceModule other = (BuiltinSourceModule)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws ModelException {
        IBuffer buffer;
        boolean isWorkingCopy = this.isWorkingCopy();
        IBuffer iBuffer = buffer = isWorkingCopy ? this.owner.createBuffer(this) : BufferManager.getDefaultBufferManager().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        char[] chars = buffer.getCharacters();
        if (chars == null || chars != null && chars.length == 0) {
            if (isWorkingCopy) {
                BuiltinSourceModule original;
                if (!this.isPrimary() && (original = new BuiltinSourceModule((BuiltinScriptFolder)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY)).isOpen()) {
                    buffer.setContents(original.getSource());
                } else {
                    char[] content = this.getBufferContent();
                    buffer.setContents(content);
                }
            } else {
                char[] content = this.getBufferContent();
                buffer.setContents(content);
            }
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    private char[] getBufferContent() throws ModelException {
        String content = this.getSourceModuleContent();
        if (content != null) {
            return content.toCharArray();
        }
        return new char[0];
    }

    public String getSource() throws ModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    public char[] getSourceAsCharArray() throws ModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return new char[0];
        }
        return buffer.getCharacters();
    }

    public String getElementName() {
        return this.name;
    }

    public org.eclipse.dltk.core.ISourceModule getWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.getWorkingCopy(new WorkingCopyOwner(){}, null, monitor);
    }

    public org.eclipse.dltk.core.ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        return this;
    }

    public boolean exists() {
        return this.isPrimary();
    }

    public boolean canBeRemovedFromCache() {
        return super.canBeRemovedFromCache();
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        return super.canBufferBeRemovedFromCache(buffer);
    }

    public void close() throws ModelException {
        super.close();
    }

    protected void closing(Object info) {
    }

    public IModelElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new BuiltinSourceModule((BuiltinScriptFolder)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY);
    }

    public IResource getUnderlyingResource() throws ModelException {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return super.getUnderlyingResource();
    }

    public boolean isConsistent() {
        return !ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().contains(this);
    }

    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
        this.openWhenClosed(this.createElementInfo(), monitor);
    }

    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws ModelException {
        if (!this.isWorkingCopy()) {
            super.openParent(childInfo, newElements, pm);
        }
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelException {
        if (this.isWorkingCopy()) {
            throw new RuntimeException("not implemented");
        }
        super.save(pm, force);
    }

    public void reconcile(boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws ModelException {
    }

    public org.eclipse.dltk.core.ISourceModule getPrimary() {
        return (org.eclipse.dltk.core.ISourceModule)this.getPrimaryElement(true);
    }

    protected void updateTimeStamp(BuiltinSourceModule original) throws ModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new ModelException(new ModelStatus(995));
        }
        ((SourceModuleElementInfo)this.getElementInfo()).timestamp = timeStamp;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = ModelManager.getModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        return ((SourceModuleElementInfo)info).timestamp != this.getResource().getModificationStamp();
    }

    public IModelElement getElementAt(int position) throws ModelException {
        IModelElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    public ISourceRange getSourceRange() throws ModelException {
        return ((SourceModuleElementInfo)this.getElementInfo()).getSourceRange();
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK ExSource Module:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public IType[] getTypes() throws ModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '#': {
                if (!DLTKCore.DEBUG) break;
                System.err.println("Add import support in SourceModule getHandleFromMemento");
                break;
            }
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                ModelElement type = (ModelElement)((Object)this.getType(typeName));
                return type.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '{';
    }

    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    public InputStream getContents() throws CoreException {
        String builtinModuleContent = this.getSourceModuleContent();
        if (builtinModuleContent == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(builtinModuleContent.getBytes());
        return input;
    }

    private String getSourceModuleContent() {
        BuiltinProjectFragment fragment = (BuiltinProjectFragment)this.getProjectFragment();
        String builtinModuleContent = fragment.builtinProvider.getBuiltinModuleContent(this.name);
        return builtinModuleContent;
    }

    public IPath getFullPath() {
        return new Path(this.name);
    }

    public String getName() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().copy(elements, containers, null, renamings, replace, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        this.copy(container, sibling, rename, replace, monitor);
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws ModelException {
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
    }

    public IModelElement[] codeSelect(int offset, int length) throws ModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IModelElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws ModelException {
        return super.codeSelect(this, offset, length, owner);
    }

    public IPackageDeclaration getPackageDeclaration(String pkg) {
        return new PackageDeclaration(this, pkg);
    }

    public IPackageDeclaration[] getPackageDeclarations() throws ModelException {
        ArrayList list = this.getChildrenOfType(10);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    public IMethod getMethod(String selector) {
        return new SourceMethod(this, selector);
    }

    public IMethod[] getMethods() throws ModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    public IModelElement getModelElement() {
        return this;
    }

    public IPath getScriptFolder() {
        return null;
    }

    public char[] getFileName() {
        return this.getPath().toOSString().toCharArray();
    }

    public String getSourceContents() {
        try {
            return this.getSource();
        }
        catch (ModelException e) {
            e.printStackTrace();
            return "";
        }
    }

    public org.eclipse.dltk.core.ISourceModule getSourceModule() {
        return this;
    }

    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getFields() throws ModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public IType[] getAllTypes() throws ModelException {
        IType[] types = this.getTypes();
        ArrayList<IType> allTypes = new ArrayList<IType>(types.length);
        ArrayList<IType> typesToTraverse = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            IType type = (IType)typesToTraverse.get(0);
            typesToTraverse.remove(type);
            allTypes.add(type);
            types = type.getTypes();
            i = 0;
            while (i < types.length) {
                typesToTraverse.add(types[i]);
                ++i;
            }
        }
        IType[] arrayOfAllTypes = new IType[allTypes.size()];
        allTypes.toArray(arrayOfAllTypes);
        return arrayOfAllTypes;
    }

    public boolean isBuiltin() {
        return true;
    }
}

