/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching;

import java.io.IOException;
import java.text.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.compiler.env.INameEnvironment;
import org.eclipse.dltk.compiler.env.ISourceType;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.FieldDeclarationMatch;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.MethodDeclarationMatch;
import org.eclipse.dltk.core.search.MethodReferenceMatch;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeDeclarationMatch;
import org.eclipse.dltk.core.search.TypeReferenceMatch;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.core.search.matching.PossibleMatch;
import org.eclipse.dltk.internal.compiler.env.AccessRestriction;
import org.eclipse.dltk.internal.compiler.impl.ITypeRequestor;
import org.eclipse.dltk.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.dltk.internal.compiler.lookup.SourceModuleScope;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.NameLookup;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.internal.core.search.IndexSelector;
import org.eclipse.dltk.internal.core.search.matching.AndPattern;
import org.eclipse.dltk.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.PossibleMatchSet;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.core.util.Util;

public class MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IDLTKSearchScope scope;
    public IProgressMonitor progressMonitor;
    public ISourceModule[] workingCopies;
    public HandleFactory handleFactory;
    public char[][][] allSuperTypeNames;
    public IMatchLocatorParser parser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public int numberOfMatches;
    public PossibleMatch[] matchesToProcess;
    public PossibleMatch currentPossibleMatch;
    public long resultCollectorTime = 0L;
    protected int progressStep;
    protected int progressWorked;
    protected SourceModuleScope unitScope;
    protected SimpleLookupTable bindings;
    protected HashSet methodHandles;
    protected HashSet fieldHandles;

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int ratio = (int)Math.round((double)maxMemory / 6.7108864E7);
        switch (ratio) {
            case 0: 
            case 1: {
                MAX_AT_ONCE = 100;
                break;
            }
            case 2: {
                MAX_AT_ONCE = 200;
                break;
            }
            case 3: {
                MAX_AT_ONCE = 300;
                break;
            }
            default: {
                MAX_AT_ONCE = 400;
            }
        }
    }

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, ISourceModule[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static void setFocus(InternalSearchPattern pattern, IModelElement focus) {
        pattern.focus = focus;
    }

    private static HashMap workingCopiesThatCanSeeFocus(ISourceModule[] copies, IModelElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IScriptProject) && !(focus instanceof ArchiveProjectFragment)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            ISourceModule workingCopy = copies[i];
            IPath projectOrArchive = MatchLocator.getProjectOrArchive(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrArchive)) {
                boolean external = false;
                IProjectFragment frag = (IProjectFragment)workingCopy.getAncestor(3);
                if (frag != null) {
                    external = frag.isExternal();
                }
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant, external));
            }
            ++i;
        }
        return result;
    }

    public static SearchPattern createAndPattern(final SearchPattern leftPattern, final SearchPattern rightPattern) {
        return new AndPattern(0, 0){
            SearchPattern current;
            {
                this.current = searchPattern;
            }

            public SearchPattern currentPattern() {
                return this.current;
            }

            protected boolean hasNextQuery() {
                if (this.current == leftPattern) {
                    this.current = rightPattern;
                    return true;
                }
                return false;
            }

            protected void resetQuery() {
                this.current = leftPattern;
            }
        };
    }

    public static void findIndexMatches(InternalSearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IDLTKSearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static IModelElement getProjectOrArchive(IModelElement element) {
        while (!(element instanceof IScriptProject) && !(element instanceof ArchiveProjectFragment)) {
            element = element.getParent();
        }
        return element;
    }

    public static boolean isPolymorphicSearch(InternalSearchPattern pattern) {
        return pattern.isPolymorphicSearch();
    }

    public static IModelElement projectOrArchiveFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrArchive(pattern.focus);
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(ISourceModule sourceUnit, AccessRestriction accessRestriction) {
    }

    public void accept(ISourceType[] sourceTypes, AccessRestriction accessRestriction) {
    }

    protected char[][][] computeSuperTypeNames(IType focusType) {
        return null;
    }

    protected IModelElement createHandle(MethodDeclaration method, IModelElement parent) {
        if (parent instanceof IType) {
            IType type = (IType)parent;
            return this.createMethodHandle(type, new String(method.getName()));
        }
        if (parent instanceof ISourceModule) {
            return this.createMethodHandle((ISourceModule)parent, method.getName());
        }
        return null;
    }

    protected IModelElement createHandle(FieldDeclaration field, IModelElement parent) {
        if (parent instanceof IType) {
            IType type = (IType)parent;
            return this.createFieldHandle(type, new String(field.getName()));
        }
        if (parent instanceof ISourceModule) {
            return this.createFieldHandle((ISourceModule)parent, field.getName());
        }
        return null;
    }

    protected IModelElement createMethodHandle(IType type, String methodName) {
        IMethod methodHandle = type.getMethod(methodName);
        if (methodHandle instanceof SourceMethod) {
            while (this.methodHandles.contains(methodHandle)) {
                ++((SourceMethod)methodHandle).occurrenceCount;
            }
        }
        this.methodHandles.add(methodHandle);
        return methodHandle;
    }

    protected IModelElement createMethodHandle(ISourceModule module, String methodName) {
        IMethod methodHandle = module.getMethod(methodName);
        if (methodHandle instanceof SourceMethod) {
            while (this.methodHandles.contains(methodHandle)) {
                ++((SourceMethod)methodHandle).occurrenceCount;
            }
        }
        this.methodHandles.add(methodHandle);
        return methodHandle;
    }

    protected IModelElement createFieldHandle(IType type, String methodName) {
        IField fieldHandle = type.getField(methodName);
        if (fieldHandle instanceof SourceField) {
            while (this.fieldHandles.contains(fieldHandle)) {
                ++((SourceField)fieldHandle).occurrenceCount;
            }
        }
        this.fieldHandles.add(fieldHandle);
        return fieldHandle;
    }

    protected IModelElement createFieldHandle(ISourceModule module, String methodName) {
        IField fieldHandle = module.getField(methodName);
        if (fieldHandle instanceof SourceField) {
            while (this.fieldHandles.contains(fieldHandle)) {
                ++((SourceField)fieldHandle).occurrenceCount;
            }
        }
        this.fieldHandles.add(fieldHandle);
        return fieldHandle;
    }

    protected IType createTypeHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof SourceModule) {
            return ((SourceModule)openable).getType(simpleTypeName);
        }
        if (openable instanceof ExternalSourceModule) {
            return ((ExternalSourceModule)openable).getType(simpleTypeName);
        }
        if (openable instanceof BuiltinSourceModule) {
            return ((BuiltinSourceModule)openable).getType(simpleTypeName);
        }
        return null;
    }

    protected ISourceModule createSourceModuleHandle() {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof ISourceModule) {
            return (ISourceModule)((Object)openable);
        }
        return null;
    }

    protected IMethod createMethodHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof SourceModule) {
            return ((SourceModule)openable).getMethod(simpleTypeName);
        }
        if (openable instanceof ExternalSourceModule) {
            return ((ExternalSourceModule)openable).getMethod(simpleTypeName);
        }
        return null;
    }

    protected IField createFieldHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof SourceModule) {
            return ((SourceModule)openable).getField(simpleTypeName);
        }
        if (openable instanceof ExternalSourceModule) {
            return ((ExternalSourceModule)openable).getField(simpleTypeName);
        }
        return null;
    }

    protected boolean encloses(IModelElement element) {
        return element != null && this.scope.encloses(element);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getMethodBodies(ModuleDeclaration unit, MatchingNodeSet nodeSet) {
        try {
            this.parser.setNodeSet(nodeSet);
            this.parser.parseBodies(unit);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parser.setNodeSet(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.parser.setNodeSet(null);
            return;
        }
    }

    public void initialize(ScriptProject project, int possibleMatchSize) throws ModelException {
        if (this.nameEnvironment != null && possibleMatchSize != 1) {
            this.nameEnvironment.cleanup();
        }
        ISearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.workingCopies);
        this.nameEnvironment = possibleMatchSize == 1 ? searchableEnvironment : null;
        this.lookupEnvironment = new LookupEnvironment(this, this.nameEnvironment);
        IDLTKLanguageToolkit tk = null;
        try {
            tk = DLTKLanguageManager.getLanguageToolkit(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (tk == null) {
            throw new ModelException(new ModelStatus(997, (IModelElement)project, "Language Toolkit not found on project"));
        }
        this.parser = DLTKLanguageManager.createMatchParser(tk.getNatureId(), this);
        this.nameLookup = searchableEnvironment.getNameLookup();
        this.numberOfMatches = 0;
        this.matchesToProcess = new PossibleMatch[possibleMatchSize];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void locateMatches(ScriptProject scriptProject, PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        this.initialize(scriptProject, length);
        int i = start;
        int maxUnits = start + length;
        while (true) {
            block9: {
                Object var8_8;
                if (i >= maxUnits) {
                    return;
                }
                PossibleMatch possibleMatch = possibleMatches[i];
                try {
                    if (!this.parse(possibleMatch)) {
                        var8_8 = null;
                        possibleMatch.cleanUp();
                        break block9;
                    }
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    this.process(possibleMatch);
                    if (this.numberOfMatches > 0 && this.matchesToProcess[this.numberOfMatches - 1] == possibleMatch) {
                        --this.numberOfMatches;
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    possibleMatch.cleanUp();
                    throw throwable;
                }
                {
                    var8_8 = null;
                    possibleMatch.cleanUp();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parse(PossibleMatch possibleMatch) {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (BasicSearchEngine.VERBOSE) {
                System.out.println("Parsing " + possibleMatch.openable.toStringWithAncestors());
            }
            this.parser.setNodeSet(possibleMatch.nodeSet);
            ModuleDeclaration parsedUnit = this.parser.parse(possibleMatch);
            if (parsedUnit != null) {
                this.getMethodBodies(parsedUnit, possibleMatch.nodeSet);
                possibleMatch.parsedUnit = parsedUnit;
                int size = this.matchesToProcess.length;
                if (this.numberOfMatches == size) {
                    this.matchesToProcess = new PossibleMatch[size == 0 ? 1 : size * 2];
                    System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.numberOfMatches);
                }
                this.matchesToProcess[this.numberOfMatches++] = possibleMatch;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.parser.setNodeSet(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.parser.setNodeSet(null);
            return true;
        }
    }

    protected void locateMatches(ScriptProject scriptProject, PossibleMatchSet matchSet, int expected) throws CoreException {
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(scriptProject.getProjectFragments());
        int length = possibleMatches.length;
        if (this.progressMonitor != null && expected > length) {
            this.progressWorked += expected - length;
            this.progressMonitor.worked(expected - length);
        }
        int index = 0;
        while (index < length) {
            int max = Math.min(MAX_AT_ONCE, length - index);
            this.locateMatches(scriptProject, possibleMatches, index, max);
            index += max;
        }
        this.patternLocator.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        int docsLength = searchDocuments.length;
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            int i = 0;
            while (i < docsLength) {
                System.out.println("\t" + searchDocuments[i]);
                ++i;
            }
            System.out.println("]");
        }
        int n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
        this.progressStep = docsLength < n ? 1 : docsLength / n;
        this.progressWorked = 0;
        ArrayList<ISourceModule> copies = new ArrayList<ISourceModule>();
        int i = 0;
        while (i < docsLength) {
            SearchDocument document = searchDocuments[i];
            if (document instanceof WorkingCopyDocument) {
                copies.add(((WorkingCopyDocument)document).workingCopy);
            }
            ++i;
        }
        int copiesLength = copies.size();
        this.workingCopies = new ISourceModule[copiesLength];
        copies.toArray(this.workingCopies);
        ModelManager manager = ModelManager.getModelManager();
        this.bindings = new SimpleLookupTable();
        try {
            manager.cacheZipFiles();
            if (this.handleFactory == null) {
                this.handleFactory = new HandleFactory();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.beginTask("", searchDocuments.length);
            }
            this.patternLocator.initializePolymorphicSearch(this);
            ScriptProject previousScriptProject = null;
            PossibleMatchSet matchSet = new PossibleMatchSet();
            Util.sort(searchDocuments, new Util.Comparer(){

                public int compare(Object a, Object b) {
                    return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                }
            });
            int displayed = 0;
            String previousPath = null;
            int i2 = 0;
            while (i2 < docsLength) {
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchDocument searchDocument = searchDocuments[i2];
                searchDocuments[i2] = null;
                String pathString = searchDocument.getPath();
                if (i2 > 0 && pathString.equals(previousPath)) {
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    ++displayed;
                } else {
                    Openable openable;
                    previousPath = pathString;
                    ISourceModule workingCopy = null;
                    if (searchDocument instanceof WorkingCopyDocument) {
                        workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                        openable = (Openable)((Object)workingCopy);
                    } else {
                        openable = this.handleFactory.createOpenable(pathString, this.scope);
                    }
                    if (openable == null) {
                        if (this.progressMonitor != null) {
                            ++this.progressWorked;
                            if (this.progressWorked % this.progressStep == 0) {
                                this.progressMonitor.worked(this.progressStep);
                            }
                        }
                        ++displayed;
                    } else {
                        IResource resource = null;
                        ScriptProject scriptProject = (ScriptProject)openable.getScriptProject();
                        IResource iResource = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                        if (resource == null) {
                            resource = scriptProject.getProject();
                        }
                        if (!scriptProject.equals(previousScriptProject)) {
                            if (previousScriptProject != null) {
                                try {
                                    this.locateMatches(previousScriptProject, matchSet, i2 - displayed);
                                    displayed = i2;
                                }
                                catch (ModelException modelException) {}
                                matchSet.reset();
                            }
                            previousScriptProject = scriptProject;
                        }
                        matchSet.add(new PossibleMatch(this, resource, openable, searchDocument));
                    }
                }
                ++i2;
            }
            if (previousScriptProject != null) {
                try {
                    this.locateMatches(previousScriptProject, matchSet, docsLength - displayed);
                }
                catch (ModelException modelException) {}
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
            Object var18_20 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            return;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISourceModule[] locateModules(SearchDocument[] searchDocuments) {
        ArrayList<Openable> modules = new ArrayList<Openable>();
        int docsLength = searchDocuments.length;
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            int i = 0;
            while (i < docsLength) {
                System.out.println("\t" + searchDocuments[i]);
                ++i;
            }
            System.out.println("]");
        }
        int n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
        this.progressStep = docsLength < n ? 1 : docsLength / n;
        this.progressWorked = 0;
        ArrayList<ISourceModule> copies = new ArrayList<ISourceModule>();
        int i = 0;
        while (i < docsLength) {
            SearchDocument document = searchDocuments[i];
            if (document instanceof WorkingCopyDocument) {
                copies.add(((WorkingCopyDocument)document).workingCopy);
            }
            ++i;
        }
        int copiesLength = copies.size();
        this.workingCopies = new ISourceModule[copiesLength];
        copies.toArray(this.workingCopies);
        ModelManager manager = ModelManager.getModelManager();
        this.bindings = new SimpleLookupTable();
        try {
            manager.cacheZipFiles();
            if (this.handleFactory == null) {
                this.handleFactory = new HandleFactory();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.beginTask("", searchDocuments.length);
            }
            this.patternLocator.initializePolymorphicSearch(this);
            Util.sort(searchDocuments, new Util.Comparer(){

                public int compare(Object a, Object b) {
                    return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                }
            });
            int displayed = 0;
            String previousPath = null;
            int i2 = 0;
            while (i2 < docsLength) {
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchDocument searchDocument = searchDocuments[i2];
                searchDocuments[i2] = null;
                String pathString = searchDocument.getPath();
                if (i2 > 0 && pathString.equals(previousPath)) {
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    ++displayed;
                } else {
                    Openable openable;
                    previousPath = pathString;
                    ISourceModule workingCopy = null;
                    if (searchDocument instanceof WorkingCopyDocument) {
                        workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                        openable = (Openable)((Object)workingCopy);
                    } else {
                        openable = this.handleFactory.createOpenable(pathString, this.scope);
                    }
                    if (openable == null) {
                        if (this.progressMonitor != null) {
                            ++this.progressWorked;
                            if (this.progressWorked % this.progressStep == 0) {
                                this.progressMonitor.worked(this.progressStep);
                            }
                        }
                        ++displayed;
                    } else {
                        IResource resource = null;
                        ScriptProject scriptProject = (ScriptProject)openable.getScriptProject();
                        IResource iResource = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                        if (resource == null) {
                            resource = scriptProject.getProject();
                        }
                        if (!modules.contains(openable)) {
                            modules.add(openable);
                        }
                    }
                }
                ++i2;
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
            Object var17_19 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            return modules.toArray(new ISourceModule[modules.size()]);
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            throw throwable;
        }
    }

    public SearchMatch newDeclarationMatch(IModelElement element, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return this.newDeclarationMatch(element, accuracy, offset, length, participant, resource);
    }

    public SearchMatch newDeclarationMatch(IModelElement element, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        switch (element.getElementType()) {
            case 7: {
                return new TypeDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 8: {
                return new FieldDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 9: {
                return new MethodDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
        }
        return null;
    }

    public SearchMatch newFieldReferenceMatch(IModelElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = false;
        boolean isReadAccess = false;
        boolean isWriteAccess = false;
        if (enclosingElement instanceof IParent && reference instanceof FieldDeclaration) {
            IParent parent = (IParent)((Object)enclosingElement);
            try {
                FieldDeclaration decl = (FieldDeclaration)reference;
                IModelElement[] children = parent.getChildren();
                boolean found = false;
                int i = 0;
                while (i < children.length) {
                    if (children[i].getElementName().equals(decl.getName()) && children[i] instanceof IField) {
                        enclosingElement = children[i];
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    return null;
                }
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        return new FieldReferenceMatch(enclosingElement, reference, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newLocalVariableReferenceMatch(IModelElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        return null;
    }

    public SearchMatch newMethodReferenceMatch(IModelElement enclosingElement, int accuracy, int offset, int length, boolean isConstructor, boolean isSynthetic, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new MethodReferenceMatch(enclosingElement, accuracy, offset, length, isConstructor, isSynthetic, false, participant, resource, reference);
    }

    public SearchMatch newPackageReferenceMatch(IModelElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        return null;
    }

    public TypeReferenceMatch newTypeReferenceMatch(IModelElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new TypeReferenceMatch(enclosingElement, accuracy, offset, length, false, participant, resource);
    }

    public TypeReferenceMatch newTypeReferenceMatch(IModelElement enclosingElement, int accuracy, ASTNode reference) {
        return this.newTypeReferenceMatch(enclosingElement, accuracy, reference.sourceStart(), reference.sourceEnd() - reference.sourceStart() + 1, reference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(PossibleMatch possibleMatch) throws CoreException {
        this.currentPossibleMatch = possibleMatch;
        ModuleDeclaration unit = possibleMatch.parsedUnit;
        try {
            block6: {
                block5: {
                    if (unit == null) break block5;
                    if (!unit.isEmpty()) break block6;
                }
                Object var3_3 = null;
                this.currentPossibleMatch = null;
                return;
            }
            this.reportMatching(unit);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.currentPossibleMatch = null;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.currentPossibleMatch = null;
            return;
        }
    }

    protected void reduceParseTree(ModuleDeclaration unit) {
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    protected void report(SearchMatch match) throws CoreException {
        long start = -1L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
            System.out.println("Reporting match");
            System.out.println("\tResource: " + match.getResource());
            System.out.println("\tPositions: [offset=" + match.getOffset() + ", length=" + match.getLength() + "]");
            try {
                ModelElement modelElement = (ModelElement)match.getElement();
                System.out.println("\tJava element: " + modelElement.toStringWithAncestors());
                if (!modelElement.exists()) {
                    System.out.println("\t\tWARNING: this element does NOT exist!");
                }
            }
            catch (Exception exception) {}
            if (match instanceof TypeReferenceMatch) {
                try {
                    int length;
                    IModelElement[] others;
                    TypeReferenceMatch typeRefMatch = (TypeReferenceMatch)match;
                    ModelElement local = (ModelElement)typeRefMatch.getLocalElement();
                    if (local != null) {
                        System.out.println("\tLocal element: " + local.toStringWithAncestors());
                    }
                    if ((others = typeRefMatch.getOtherElements()) != null && (length = others.length) > 0) {
                        System.out.println("\tOther elements:");
                        int i = 0;
                        while (i < length) {
                            ModelElement other = (ModelElement)others[i];
                            System.out.println("\t\t- " + other.toStringWithAncestors());
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            System.out.println(match.getAccuracy() == 0 ? "\tAccuracy: EXACT_MATCH" : "\tAccuracy: POTENTIAL_MATCH");
            System.out.print("\tRule: ");
            if (match.isExact()) {
                System.out.println("EXACT");
            } else if (match.isEquivalent()) {
                System.out.println("EQUIVALENT");
            } else if (match.isErasure()) {
                System.out.println("ERASURE");
            } else {
                System.out.println("INVALID RULE");
            }
            System.out.println("\tRaw: " + match.isRaw());
        }
        if (this.requestor != null) {
            this.requestor.acceptSearchMatch(match);
        }
        if (BasicSearchEngine.VERBOSE) {
            this.resultCollectorTime += System.currentTimeMillis() - start;
        }
    }

    protected void reportAccurateTypeReference(SearchMatch match, ASTNode typeRef, char[] name) throws CoreException {
    }

    protected void reportBinaryMemberDeclaration(IResource resource, IMember binaryMember, int accuracy) throws CoreException {
    }

    protected void reportMatching(Annotation[] annotations, IModelElement enclosingElement, MatchingNodeSet nodeSet, boolean matchedContainer, boolean enclosesElement) throws CoreException {
    }

    protected void reportMatching(ModuleDeclaration unit) throws CoreException {
        ASTNode[] nodes;
        FieldDeclaration[] fields;
        MethodDeclaration[] methods;
        MatchingNodeSet nodeSet = this.currentPossibleMatch.nodeSet;
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Report matching: ");
            int size = nodeSet.matchingNodes == null ? 0 : nodeSet.matchingNodes.elementSize;
            System.out.print("\t- node set: accurate=" + size);
            size = nodeSet.possibleMatchingNodesSet == null ? 0 : nodeSet.possibleMatchingNodesSet.elementSize;
            System.out.println(", possible=" + size);
        }
        this.unitScope = null;
        if (nodeSet.matchingNodes.elementSize == 0) {
            return;
        }
        this.methodHandles = new HashSet();
        this.fieldHandles = new HashSet();
        boolean matchedUnitContainer = (this.matchContainer & 1) != 0;
        TypeDeclaration[] types = unit.getTypes();
        if (types != null) {
            int i = 0;
            int l = types.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration type = types[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(type);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(type, null, accuracy, nodeSet, 1);
                ++i;
            }
        }
        if ((methods = unit.getFunctions()) != null) {
            int i = 0;
            int l = methods.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                MethodDeclaration method = methods[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(method);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(unit, method, null, accuracy, nodeSet);
                ++i;
            }
        }
        if ((fields = unit.getVariables()) != null) {
            int i = 0;
            int l = fields.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                FieldDeclaration method = fields[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(method);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(unit, method, null, accuracy, nodeSet);
                ++i;
            }
        }
        if ((nodes = nodeSet.matchingNodes(unit.sourceStart(), unit.sourceEnd())) != null) {
            if ((this.matchContainer & 1) != 0) {
                ISourceModule enclosingElement = this.createSourceModuleHandle();
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (DLTKCore.DEBUG) {
                        System.out.println("TODO: Searching. Add scope support.");
                    }
                    this.patternLocator.matchReportReference(node, enclosingElement, null, level, this);
                    ++i;
                }
            }
            int i = 0;
            int l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
        this.methodHandles = null;
        this.bindings.removeKey(this.pattern);
    }

    protected void reportMatching(TypeDeclaration type, IModelElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        ASTNode[] nodes;
        FieldDeclaration[] fields;
        TypeDeclaration[] memberTypes;
        boolean matchedClassContainer;
        IModelElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(type.getName());
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(type.getName());
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.getType(type.getName(), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        boolean enclosesElement = this.encloses(enclosingElement);
        if (accuracy > -1 && enclosesElement) {
            int offset = type.sourceStart();
            SearchMatch match = this.patternLocator.newDeclarationMatch(type, enclosingElement, accuracy, type.sourceEnd() - offset + 1, this);
            this.report(match);
        }
        boolean bl = matchedClassContainer = (this.matchContainer & 2) != 0;
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Searching. add variable handling here...");
        }
        boolean typeInHierarchy = true;
        MethodDeclaration[] methods = type.getMethods();
        if (methods != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i = 0;
            int l = methods.length;
            while (i < l) {
                MethodDeclaration method = methods[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(method);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(type, method, enclosingElement, value, true, nodeSet);
                ++i;
            }
        }
        if ((memberTypes = type.getTypes()) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration memberType = memberTypes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(memberType);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(memberType, enclosingElement, value, nodeSet, 1);
                ++i;
            }
        }
        if ((fields = type.getVariables()) != null) {
            int i = 0;
            int l = fields.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                FieldDeclaration field = fields[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(field);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(type, field, enclosingElement, value, true, nodeSet);
                ++i;
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(type.sourceStart(), type.sourceEnd())) != null) {
            int l;
            if ((this.matchContainer & 4) != 0 && this.encloses(enclosingElement)) {
                int i = 0;
                l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (DLTKCore.DEBUG) {
                        System.out.println("TODO: Searching. Add scope support.");
                    }
                    this.patternLocator.matchReportReference(node, enclosingElement, null, level, this);
                    ++i;
                }
                return;
            }
            int i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, MethodDeclaration method, IModelElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IModelElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(method, parent)) != null) {
            int nameSourceStart = method.sourceStart();
            if (this.encloses(enclosingElement)) {
                int length;
                SearchMatch match = null;
                if (DLTKCore.DEBUG) {
                    System.out.println("TODO: AST Add constructor support.");
                }
                if ((match = this.patternLocator.newDeclarationMatch(method, enclosingElement, accuracy, length = method.sourceEnd() - nameSourceStart, this)) != null) {
                    this.report(match);
                }
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.sourceStart(), method.sourceEnd())) != null) {
            int l;
            if ((this.matchContainer & 2) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int i = 0;
                    l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        if (DLTKCore.DEBUG) {
                            System.out.println("TODO: Searching. Add scope support.");
                        }
                        this.patternLocator.matchReportReference(node, enclosingElement, null, level, this);
                        ++i;
                    }
                    return;
                }
            }
            int i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, FieldDeclaration field, IModelElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IModelElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(field, parent)) != null) {
            int nameSourceStart = field.sourceStart();
            if (this.encloses(enclosingElement)) {
                int length;
                SearchMatch match = null;
                if (DLTKCore.DEBUG) {
                    System.out.println("TODO: AST Add constructor support.");
                }
                if ((match = this.patternLocator.newDeclarationMatch(field, enclosingElement, accuracy, length = field.sourceEnd() - nameSourceStart, this)) != null) {
                    this.report(match);
                }
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(field.sourceStart(), field.sourceEnd())) != null) {
            int l;
            if ((this.matchContainer & 2) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(field, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int i = 0;
                    l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        if (DLTKCore.DEBUG) {
                            System.out.println("TODO: Searching. Add scope support.");
                        }
                        this.patternLocator.matchReportReference(node, enclosingElement, null, level, this);
                        ++i;
                    }
                    return;
                }
            }
            int i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(ModuleDeclaration module, FieldDeclaration field, IModelElement parent, int accuracy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IModelElement enclosingElement = null;
        if (accuracy > -1) {
            if (parent == null) {
                parent = this.createSourceModuleHandle();
            }
            if ((enclosingElement = this.createHandle(field, parent)) == null) {
                enclosingElement = this.createFieldHandle(field.getName());
            }
            if (enclosingElement != null) {
                int nameSourceStart = field.sourceStart();
                if (this.encloses(enclosingElement)) {
                    int length;
                    SearchMatch match = null;
                    if (DLTKCore.DEBUG) {
                        System.out.println("TODO: AST Add constructor support.");
                    }
                    if ((match = this.patternLocator.newDeclarationMatch(field, enclosingElement, accuracy, length = field.sourceEnd() - nameSourceStart, this)) != null) {
                        this.report(match);
                    }
                }
            }
        }
        if ((nodes = nodeSet.matchingNodes(field.sourceStart(), field.sourceEnd())) != null) {
            int l;
            if (parent == null) {
                parent = this.createSourceModuleHandle();
            }
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(field, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int i = 0;
                    l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        if (DLTKCore.DEBUG) {
                            System.out.println("TODO: Searching. Add scope support.");
                        }
                        this.patternLocator.matchReportReference(node, enclosingElement, null, level, this);
                        ++i;
                    }
                    return;
                }
            }
            int i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(ModuleDeclaration module, MethodDeclaration method, IModelElement parent, int accuracy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IModelElement enclosingElement = null;
        if (accuracy > -1) {
            if (parent == null) {
                parent = this.createSourceModuleHandle();
            }
            if ((enclosingElement = this.createHandle(method, parent)) == null) {
                enclosingElement = this.createMethodHandle(method.getName());
            }
            if (enclosingElement != null) {
                int nameSourceStart = method.sourceStart();
                if (this.encloses(enclosingElement)) {
                    int length;
                    SearchMatch match = null;
                    if (DLTKCore.DEBUG) {
                        System.out.println("TODO: AST Add constructor support.");
                    }
                    if ((match = this.patternLocator.newDeclarationMatch(method, enclosingElement, accuracy, length = method.sourceEnd() - nameSourceStart, this)) != null) {
                        this.report(match);
                    }
                }
            }
        }
        if ((nodes = nodeSet.matchingNodes(method.sourceStart(), method.sourceEnd())) != null) {
            int l;
            if (parent == null) {
                parent = this.createSourceModuleHandle();
            }
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int i = 0;
                    l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        if (DLTKCore.DEBUG) {
                            System.out.println("TODO: Searching. Add scope support.");
                        }
                        this.patternLocator.matchReportReference(node, enclosingElement, null, level, this);
                        ++i;
                    }
                    return;
                }
            }
            int i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected IType findTypeFrom(IModelElement[] childs, String name, String parentName, char delimiter) {
        try {
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof IType) {
                    IType type = (IType)childs[i];
                    String qname = String.valueOf(name) + delimiter + type.getElementName();
                    if (qname.equals(parentName)) {
                        return type;
                    }
                    IType val = this.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                    if (val != null) {
                        return val;
                    }
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class WorkingCopyDocument
    extends DLTKSearchDocument {
        public ISourceModule workingCopy;

        WorkingCopyDocument(ISourceModule workingCopy, SearchParticipant participant, boolean external) {
            super(workingCopy.getPath().toString(), participant, external);
            this.charContents = ((SourceModule)workingCopy).getSourceContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }

    public class WrappedCoreException
    extends RuntimeException {
        private static final long serialVersionUID = 8354329870126121212L;
        public CoreException coreException;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }
}

