/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.expressions;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

public class CallExpression
extends Expression {
    private ASTNode receiver;
    private String name;
    private CallArgumentsList args;

    public CallExpression(int start, int end, ASTNode receiver, String name, CallArgumentsList args) {
        super(start, end);
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (args == null) {
            args = new CallArgumentsList();
        }
        this.receiver = receiver;
        this.name = name;
        this.args = args;
    }

    public CallExpression(ASTNode receiver, String name, CallArgumentsList args) {
        this(0, 0, receiver, name, args);
    }

    public int getKind() {
        return 0;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit(this)) {
            if (this.receiver != null) {
                this.receiver.traverse(pVisitor);
            }
            if (this.args != null) {
                this.args.traverse(pVisitor);
            }
            pVisitor.endvisit(this);
        }
    }

    public ASTNode getReceiver() {
        return this.receiver;
    }

    public String getName() {
        return this.name;
    }

    public CallArgumentsList getArgs() {
        return this.args;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("CallExpression" + this.getSourceRange().toString() + ":");
        if (this.receiver != null) {
            output.formatPrint("{");
            this.receiver.printNode(output);
            output.formatPrint("}.");
        }
        output.formatPrint(String.valueOf(this.getName()) + "(");
        if (this.getArgs() != null) {
            this.getArgs().printNode(output);
        }
        output.formatPrintLn(")");
    }
}

