/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.evaluation.types;

import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.ti.types.ClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class SimpleType
extends ClassType
implements IClassType {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_ARRAY = 2;
    public static final int TYPE_LIST = 3;
    public static final int TYPE_DICT = 4;
    public static final int TYPE_BOOLEAN = 5;
    public static final int TYPE_NONE = 6;
    public static final int TYPE_TUPLE = 7;
    public static final int TYPE_NULL = 8;
    private int fType;

    public SimpleType(int type) {
        this.fType = type;
    }

    public String getTypeName() {
        return SimpleType.getTypeString(this.fType);
    }

    public int getType() {
        return this.fType;
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 0: {
                return "string";
            }
            case 1: {
                return "number";
            }
            case 2: {
                return "array";
            }
            case 3: {
                return "list";
            }
            case 4: {
                return "dict";
            }
            case 5: {
                return "boolean";
            }
            case 7: {
                return "tuple";
            }
            case 6: {
                return "void";
            }
            case 8: {
                return "NULL";
            }
        }
        return "unknown";
    }

    public int hashCode() {
        return this.fType ^ 0xDEADBEEF;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleType) {
            SimpleType o2 = (SimpleType)obj;
            return this.fType == o2.fType;
        }
        return false;
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public String getModelKey() {
        return null;
    }
}

