/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.protalker.engine;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProTalkerBridge
implements OleListener {
    public static final int VOICE_MALE = 0;
    public static final int VOICE_FEMALE = 1;
    private static final String SpeakWebText = "SpeakWebText";
    private static final String AboutDlg = "AboutDlg";
    private static final String GeneralDlg = "GeneralDlg";
    private static final String Pause = "Pause";
    private static final String Start = "Start";
    private static final String Resume = "Resume";
    private static final String Reset = "Reset";
    private static final String Speak = "Speak";
    private static final String SendText = "SendText";
    private static final String AboutBox = "AboutBox";
    private static final String Gender = "Gender";
    private static final String Age = "Age";
    private static final String ModeGuid = "ModeGuid";
    private static final String Speed = "Speed";
    private static final String Pitch = "Pitch";
    private static final String Volume = "Volume";
    private static final String UseButton = "UseButton";
    private OleControlSite site = null;
    private OleAutomation auto = null;
    private OleFrame frame = null;
    private Vector<IVoiceEventListener> indexListener = new Vector();
    private Shell parent = new Shell();

    ProTalkerBridge(Display display) {
        this.parent.setLayout((Layout)new FillLayout());
        this.frame = new OleFrame((Composite)this.parent, 0);
        try {
            this.site = new OleControlSite((Composite)this.frame, 0, "PTSVR.PtSvrCtrl.1");
        }
        catch (SWTException sWTException) {
            this.site = null;
            return;
        }
        this.auto = new OleAutomation((OleClientSite)this.site);
        this.site.doVerb(-1);
        int i = 0;
        while (i < 10) {
            this.site.addEventListener(i, (OleListener)this);
            ++i;
        }
        this.setVoice(0);
    }

    public void dispose() {
        this.auto.dispose();
        this.parent.dispose();
    }

    private Variant getProperty(String name) {
        int id = this.auto.getIDsOfNames(new String[]{name})[0];
        return this.auto.getProperty(id);
    }

    private void setProperty(String name, Variant value) {
        int id = this.auto.getIDsOfNames(new String[]{name})[0];
        this.auto.setProperty(id, value);
    }

    private int getInt(String name) {
        return this.getProperty(name).getInt();
    }

    private void setInt(String name, int value) {
        this.setProperty(name, new Variant(value));
    }

    private String getString(String name) {
        return this.getProperty(name).getString();
    }

    private void setString(String name, String value) {
        this.setProperty(name, new Variant(value));
    }

    private boolean getBoolean(String name) {
        return this.getProperty(name).getBoolean();
    }

    private void setBoolean(String name, boolean value) {
        this.setProperty(name, new Variant(value));
    }

    private void invoke(String name) {
        this.invoke(name, new Variant[0]);
    }

    private void invoke(String name, Variant[] arg) {
        int id = this.auto.getIDsOfNames(new String[]{name})[0];
        this.auto.invoke(id, arg);
    }

    public int getGender() {
        return this.getInt(Gender);
    }

    public int getAge() {
        return this.getInt(Age);
    }

    public String getModeGuid() {
        return this.getString(ModeGuid);
    }

    public void setModeGuid(String guid) {
        this.setString(ModeGuid, guid);
    }

    public int getSpeed() {
        return this.getInt(Speed);
    }

    public void setSpeed(int value) {
        this.setInt(Speed, value);
    }

    public int getPitch() {
        return this.getInt(Pitch);
    }

    public void setPitch(int value) {
        this.setInt(Pitch, value);
    }

    public int getVolume() {
        return this.getInt(Volume);
    }

    public void setVolume(int value) {
        this.setInt(Volume, value);
    }

    public boolean getUseButton() {
        return this.getBoolean(UseButton);
    }

    public void setUseButton(boolean value) {
        this.setBoolean(UseButton, value);
    }

    public void speakWebText() {
        this.invoke(SpeakWebText);
    }

    public void aboutDlg() {
        this.invoke(AboutDlg);
    }

    public void generalDlg() {
        this.invoke(GeneralDlg);
    }

    public void pause() {
        this.invoke(Pause);
    }

    public void start() {
        this.invoke(Start);
    }

    public void resume() {
        this.invoke(Resume);
    }

    public void reset() {
        this.invoke(Reset);
        this.invoke(Speak, new Variant[]{new Variant(" ")});
        this.invoke(Reset);
        this.invoke(Speak, new Variant[]{new Variant(" ")});
    }

    public void sendText(String text) {
        this.invoke(SendText, new Variant[]{new Variant(text)});
    }

    public void aboutBox() {
        this.invoke(AboutBox);
    }

    public void speak(String text, int flags, int index) {
        StringBuffer sb = new StringBuffer();
        sb.append("\\Mrk=");
        sb.append(index);
        sb.append("\\");
        sb.append(text);
        sb.append("\\Mrk=-1\\");
        if (flags == 0) {
            this.invoke(Speak, new Variant[]{new Variant(sb.toString())});
        } else if (flags == 1) {
            this.reset();
            this.invoke(Speak, new Variant[]{new Variant(sb.toString())});
        }
    }

    public void handleEvent(OleEvent event) {
        if (event.type == 3) {
            Enumeration<IVoiceEventListener> e = this.indexListener.elements();
            while (e.hasMoreElements()) {
                e.nextElement().indexReceived(event.arguments[0].getInt());
            }
        }
    }

    public void addIndexListener(IVoiceEventListener listener) {
        this.indexListener.add(listener);
    }

    public void removeIndexListener(IVoiceEventListener listener) {
        this.indexListener.remove(listener);
    }

    public void setVoice(int type) {
        if (type == 0) {
            this.setModeGuid("{904AAB60-5D94-11D0-830A-444553540000}");
        } else if (type == 1) {
            this.setModeGuid("{904AAB61-5D94-11d0-830A-444553540000}");
        }
    }

    public boolean isAvailable() {
        return this.auto != null;
    }
}

