/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.mediator;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.mediator.IACTFReportGenerator;
import org.eclipse.actf.mediator.IACTFReportViewer;
import org.eclipse.actf.mediator.IMediatorEventListener;
import org.eclipse.actf.mediator.MediatorEvent;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.ui.util.AbstractPartListener;
import org.eclipse.actf.ui.util.PlatformUIUtil;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class Mediator {
    private static Mediator instance = new Mediator();
    private IACTFReportGenerator curRepoter;
    private IModelServiceHolder currentModelServiceHolder;
    private HashMap<IACTFReportGenerator, IACTFReport> reportMap = new HashMap();
    private HashSet<IWorkbenchPage> pageSet = new HashSet();
    private Set<IMediatorEventListener> mediatorEventLisnterSet = Collections.synchronizedSet(new HashSet());

    public static Mediator getInstance() {
        return instance;
    }

    private Mediator() {
        this.init();
    }

    public void setReport(IACTFReportGenerator iACTFReportGenerator, IACTFReport iACTFReport) {
        this.reportMap.put(iACTFReportGenerator, iACTFReport);
        this.reportChanged(new MediatorEvent(this, this.currentModelServiceHolder, iACTFReportGenerator, iACTFReport));
    }

    public IACTFReport getReport(IACTFReportGenerator iACTFReportGenerator) {
        return this.getEvaluationResult(null, iACTFReportGenerator);
    }

    private IACTFReport getEvaluationResult(IModelServiceHolder iModelServiceHolder, IACTFReportGenerator iACTFReportGenerator) {
        if (this.reportMap.containsKey(iACTFReportGenerator)) {
            return this.reportMap.get(iACTFReportGenerator);
        }
        return null;
    }

    private void initPage(IWorkbenchPage iWorkbenchPage) {
        if (this.pageSet.add(iWorkbenchPage)) {
            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
            int n = 0;
            while (n < iViewReferenceArray.length) {
                IViewPart iViewPart = iViewReferenceArray[n].getView(false);
                if (iViewPart != null && iViewPart instanceof IMediatorEventListener) {
                    this.addMediatorEventListener((IMediatorEventListener)iViewPart);
                }
                ++n;
            }
            iWorkbenchPage.addPartListener((IPartListener2)new AbstractPartListener(){

                public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                    if (iWorkbenchPart instanceof IACTFReportGenerator && iWorkbenchPart != Mediator.this.curRepoter) {
                        Mediator.this.curRepoter = (IACTFReportGenerator)iWorkbenchPart;
                        Mediator.this.reporterViewChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                    }
                    if (iWorkbenchPart instanceof IModelServiceHolder && iWorkbenchPart != Mediator.this.currentModelServiceHolder) {
                        Mediator.this.currentModelServiceHolder = (IModelServiceHolder)iWorkbenchPart;
                        Mediator.this.modelserviceChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                    }
                }

                public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                    if (iWorkbenchPart instanceof IMediatorEventListener) {
                        Mediator.this.removeMediatorEventListener((IMediatorEventListener)iWorkbenchPart);
                    }
                }

                public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                    if (iWorkbenchPart instanceof IACTFReportViewer) {
                        IACTFReportViewer iACTFReportViewer = (IACTFReportViewer)iWorkbenchPart;
                        if (Mediator.this.currentModelServiceHolder != null) {
                            iACTFReportViewer.reportChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                        }
                        Mediator.this.addMediatorEventListener(iACTFReportViewer);
                    } else if (iWorkbenchPart instanceof IMediatorEventListener) {
                        Mediator.this.addMediatorEventListener((IMediatorEventListener)iWorkbenchPart);
                    }
                }

                public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
                    if (iWorkbenchPart instanceof IModelServiceHolder) {
                        Mediator.this.currentModelServiceHolder = (IModelServiceHolder)iWorkbenchPart;
                        Mediator.this.modelserviceInputChanged(new MediatorEvent(Mediator.this, Mediator.this.currentModelServiceHolder, Mediator.this.curRepoter, Mediator.this.getReport(Mediator.this.curRepoter)));
                    }
                }
            });
        }
    }

    private void init() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUIUtil.getActiveWindow();
        iWorkbenchWindow.addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage iWorkbenchPage) {
            }

            public void pageClosed(IWorkbenchPage iWorkbenchPage) {
                Mediator.this.pageSet.remove(iWorkbenchPage);
            }

            public void pageOpened(IWorkbenchPage iWorkbenchPage) {
                Mediator.this.initPage(iWorkbenchPage);
            }
        });
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage != null) {
            this.initPage(iWorkbenchPage);
        }
    }

    public synchronized void addMediatorEventListener(IMediatorEventListener iMediatorEventListener) {
        this.mediatorEventLisnterSet.add(iMediatorEventListener);
    }

    public synchronized boolean removeMediatorEventListener(IMediatorEventListener iMediatorEventListener) {
        return this.mediatorEventLisnterSet.remove(iMediatorEventListener);
    }

    private synchronized void modelserviceChanged(MediatorEvent mediatorEvent) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener iMediatorEventListener = iMediatorEventListenerArray[n2];
            iMediatorEventListener.modelserviceChanged(mediatorEvent);
            ++n2;
        }
    }

    private synchronized void modelserviceInputChanged(MediatorEvent mediatorEvent) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener iMediatorEventListener = iMediatorEventListenerArray[n2];
            iMediatorEventListener.modelserviceInputChanged(mediatorEvent);
            ++n2;
        }
    }

    private synchronized void reportChanged(MediatorEvent mediatorEvent) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener iMediatorEventListener = iMediatorEventListenerArray[n2];
            iMediatorEventListener.reportChanged(mediatorEvent);
            ++n2;
        }
    }

    private synchronized void reporterViewChanged(MediatorEvent mediatorEvent) {
        IMediatorEventListener[] iMediatorEventListenerArray = this.mediatorEventLisnterSet.toArray(new IMediatorEventListener[this.mediatorEventLisnterSet.size()]);
        int n = iMediatorEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMediatorEventListener iMediatorEventListener = iMediatorEventListenerArray[n2];
            iMediatorEventListener.reportGeneratorChanged(mediatorEvent);
            ++n2;
        }
    }
}

