/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import java.util.Locale;
import org.eclipse.actf.accservice.swtbridge.IA2;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.accservice.swtbridge.ia2.Accessible2;
import org.eclipse.actf.visualization.gui.msaa.properties.AbstractPropertyInvokeSource;
import org.eclipse.actf.visualization.gui.msaa.properties.AttributePropertySource;
import org.eclipse.actf.visualization.gui.msaa.properties.ObjectArrayPropertySource;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2.IA2ExtendedStatesMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2.IA2LocalizedExtendedStatesMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2.IA2RelationMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2.IA2RelationsMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2.IA2ScrollToMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2.IA2ScrollToPointMethod;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Accessible2PropertySource
extends AbstractPropertyInvokeSource
implements IPropertySource {
    private Accessible2 accessible2;
    private static final String PID_IA2_nRelations = "nRelations";
    private static final String PID_IA2_relations = "relations";
    private static final String PID_IA2_relation = "relation";
    private static final String PID_IA2_role = "role";
    private static final String PID_IA2_groupPosition = "groupPosition";
    private static final String PID_IA2_states = "states";
    private static final String PID_IA2_extendedRole = "extendedRole";
    private static final String PID_IA2_localizedExtendedRole = "localizedExtendedRole";
    private static final String PID_IA2_nExtendedStates = "nExtendedStates";
    private static final String PID_IA2_extendedStates = "extendedStates";
    private static final String PID_IA2_localizedExtendedStates = "localizedExtendedStates";
    private static final String PID_IA2_uniqueID = "uniqueID";
    private static final String PID_IA2_windowHandle = "windowHandle";
    private static final String PID_IA2_indexInParent = "indexInParent";
    private static final String PID_IA2_locale = "locale";
    private static final String PID_IA2_attributes = "attributes";
    private static final String PID_IA2_scrollTo = "scrollTo";
    private static final String PID_IA2_scrollToPoint = "scrollToPoint";
    private static final IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"nRelations", "nRelations"), new PropertyDescriptor((Object)"relations", "relations"), new PropertyDescriptor((Object)"role", "role"), new PropertyDescriptor((Object)"groupPosition", "groupPosition"), new PropertyDescriptor((Object)"states", "states"), new PropertyDescriptor((Object)"extendedRole", "extendedRole"), new PropertyDescriptor((Object)"localizedExtendedRole", "localizedExtendedRole"), new PropertyDescriptor((Object)"nExtendedStates", "nExtendedStates"), new PropertyDescriptor((Object)"extendedStates", "extendedStates"), new PropertyDescriptor((Object)"localizedExtendedStates", "localizedExtendedStates"), new PropertyDescriptor((Object)"uniqueID", "uniqueID"), new PropertyDescriptor((Object)"windowHandle", "windowHandle"), new PropertyDescriptor((Object)"indexInParent", "indexInParent"), new PropertyDescriptor((Object)"locale", "locale"), new PropertyDescriptor((Object)"attributes", "attributes")};
    private static final IPropertyDescriptor[] descriptorsEx = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"relation", "relation"), new PropertyDescriptor((Object)"scrollTo", "scrollTo"), new PropertyDescriptor((Object)"scrollToPoint", "scrollToPoint")};

    public Accessible2PropertySource(Accessible2 accessible2) {
        this.accessible2 = accessible2;
        this.addMethodData(PID_IA2_scrollTo, new IA2ScrollToMethod(accessible2));
        this.addMethodData(PID_IA2_scrollToPoint, new IA2ScrollToPointMethod(accessible2));
        this.addMethodData(PID_IA2_relations, new IA2RelationsMethod(accessible2));
        this.addMethodData(PID_IA2_extendedStates, new IA2ExtendedStatesMethod(accessible2));
        this.addMethodData(PID_IA2_localizedExtendedStates, new IA2LocalizedExtendedStatesMethod(accessible2));
        this.addMethodData(PID_IA2_relation, new IA2RelationMethod(accessible2));
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public IPropertyDescriptor[] getPropertyDescriptorsExtra() {
        return descriptorsEx;
    }

    public Object getPropertyValue(Object object) {
        Object object2 = super.getPropertyValue(object);
        if (object2 != null) {
            return object2;
        }
        String string = null;
        if (PID_IA2_nRelations.equals(object)) {
            string = Integer.toString(this.accessible2.getAccessibleRelationCount());
        } else if (PID_IA2_role.equals(object)) {
            int n = this.accessible2.getAccessibleRole();
            string = String.valueOf(MSAA.getRoleText(n)) + " (0x" + Integer.toHexString(n) + ")";
        } else if (PID_IA2_groupPosition.equals(object)) {
            int[] nArray = this.accessible2.getGroupPosition();
            if (nArray != null) {
                AttributePropertySource attributePropertySource = new AttributePropertySource(null, String.valueOf(nArray[0]) + ", " + nArray[1] + " ," + nArray[2]);
                attributePropertySource.put("GroupLevel", new Integer(nArray[0]));
                attributePropertySource.put("SimilarItemsInGroup", new Integer(nArray[1]));
                attributePropertySource.put("PositionInGroup", new Integer(nArray[2]));
                return attributePropertySource;
            }
        } else if (PID_IA2_states.equals(object)) {
            int n = this.accessible2.getStates();
            string = "0x" + Integer.toHexString(n);
            Object[] objectArray = IA2.getStateTextAsArray(n);
            if (objectArray.length > 0) {
                if (objectArray.length > 1) {
                    return new ObjectArrayPropertySource(objectArray, string);
                }
                string = objectArray[0];
            }
        } else if (PID_IA2_extendedRole.equals(object)) {
            string = this.accessible2.getExtendedRole();
        } else if (PID_IA2_localizedExtendedRole.equals(object)) {
            string = this.accessible2.getLocalizedExtendedRole();
        } else if (PID_IA2_nExtendedStates.equals(object)) {
            string = Integer.toString(this.accessible2.getExtendedStateCount());
        } else if (PID_IA2_uniqueID.equals(object)) {
            string = "0x" + Integer.toHexString(this.accessible2.getUniqueID());
        } else if (PID_IA2_windowHandle.equals(object)) {
            string = "0x" + Integer.toHexString(this.accessible2.getWindowHandle());
        } else if (PID_IA2_indexInParent.equals(object)) {
            string = Integer.toString(this.accessible2.getAccessibleIndexInParent());
        } else if (PID_IA2_locale.equals(object)) {
            Locale locale = this.accessible2.getLocale();
            if (locale != null) {
                return new AttributePropertySource("Language:" + locale.getLanguage() + ";Country:" + locale.getCountry() + ";Variant:" + locale.getVariant(), locale.toString());
            }
        } else if (PID_IA2_attributes.equals(object) && (string = this.accessible2.getAttributes()) != null) {
            return new AttributePropertySource(string);
        }
        return string == null ? "null" : string;
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }
}

