/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.problem;

import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowVisionProblemGroup
extends LowVisionProblem {
    int numProblems;
    LowVisionProblem[] problems;
    LowVisionProblem representative = null;
    double sumCharacterScores;
    double groupScore;

    public LowVisionProblemGroup(Vector<LowVisionProblem> vector) throws LowVisionProblemException {
        this.numProblems = vector.size();
        if (this.numProblems <= 0) {
            throw new LowVisionProblemException("No instance belong to the group.");
        }
        this.problems = new LowVisionProblem[this.numProblems];
        this.problems[0] = this.representative = vector.elementAt(0);
        this.pageImage = this.representative.pageImage;
        this.lowVisionType = this.representative.lowVisionType;
        this.problemType = this.representative.problemType;
        this.componentType = this.representative.componentType;
        this.description = this.representative.description;
        this.sumCharacterScores = this.representative.characterScore;
        this.setRecommendations();
        this.isGroupFlag = true;
        int n = this.representative.getX();
        int n2 = n + this.representative.getWidth();
        int n3 = this.representative.getY();
        int n4 = n3 + this.representative.getHeight();
        int n5 = 1;
        while (n5 < this.numProblems) {
            LowVisionProblem lowVisionProblem = vector.elementAt(n5);
            if (lowVisionProblem.problemType != this.problemType) {
                throw new LowVisionProblemException("Problems of different types cannot be grouped.");
            }
            this.problems[n5] = lowVisionProblem;
            int n6 = lowVisionProblem.getX();
            int n7 = n6 + lowVisionProblem.getWidth();
            int n8 = lowVisionProblem.getY();
            int n9 = n8 + lowVisionProblem.getHeight();
            if (n6 < n) {
                n = n6;
            }
            if (n2 < n7) {
                n2 = n7;
            }
            if (n8 < n3) {
                n3 = n8;
            }
            if (n4 < n9) {
                n4 = n9;
            }
            this.sumCharacterScores += lowVisionProblem.characterScore;
            ++n5;
        }
        this.left = n;
        this.top = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
        this.groupScore = this.sumCharacterScores / (double)this.width / (double)this.height;
        this.calcProbability();
        this.calcPriority();
    }

    @Override
    protected void setRecommendations() {
        this.numRecommendations = this.representative.numRecommendations;
        this.recommendations = this.representative.recommendations;
    }

    private void calcProbability() throws LowVisionProblemException {
        if (this.numProblems <= 0) {
            throw new LowVisionProblemException("There are no Problems in this ProblemGroup.");
        }
        this.probability = 0.0;
        double d = 0.0;
        int n = 0;
        while (n < this.numProblems) {
            LowVisionProblem lowVisionProblem = this.problems[n];
            if (d < lowVisionProblem.probability) {
                d = lowVisionProblem.probability;
            }
            ++n;
        }
        this.probability = d;
    }

    private void calcPriority() throws LowVisionProblemException {
        if (this.problems[0].pageComponent == null) {
            this.priority = 0;
            return;
        }
        IPageImage iPageImage = this.problems[0].pageComponent.getPageImage();
        if (this.problemType == 3) {
            this.priority = 0;
        } else {
            if (iPageImage == null) {
                throw new LowVisionProblemException("PageImage of the Problem is null.");
            }
            int n = iPageImage.getWidth();
            int n2 = iPageImage.getHeight();
            this.priority = n * n2 - this.top * n - this.left;
        }
    }

    public LowVisionProblem getRepresentative() {
        return this.representative;
    }

    public int getNumProblems() {
        return this.numProblems;
    }

    public LowVisionProblem[] getProblems() {
        return this.problems;
    }

    public double getSumCharacterScores() {
        return this.sumCharacterScores;
    }

    public double getGroupScore() {
        return this.groupScore;
    }
}

