/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;

public class ColorYIQ {
    private float Y;
    private float I;
    private float Q;

    public ColorYIQ(ColorSRGB colorSRGB) throws ColorException {
        this(colorSRGB, false);
    }

    public ColorYIQ(ColorSRGB colorSRGB, boolean bl) throws ColorException {
        float f = colorSRGB.getR();
        float f2 = colorSRGB.getG();
        float f3 = colorSRGB.getB();
        this.Y = 0.299f * f + 0.587f * f2 + 0.114f * f3;
        this.I = 0.596f * f - 0.274f * f2 - 0.322f * f3;
        this.Q = 0.211f * f - 0.522f * f2 + 0.311f * f3;
        if (bl) {
            this.rangeCheck();
        } else {
            this.rangeAdjust();
        }
    }

    private void rangeCheck() throws ColorException {
        if (this.Y < 0.0f || 1.0f < this.Y) {
            throw new ColorException("Y is out of range: " + this.Y);
        }
        if (this.I < 0.0f || 1.0f < this.I) {
            throw new ColorException("I is out of range: " + this.I);
        }
        if (this.Q < 0.0f || 1.0f < this.Q) {
            throw new ColorException("Q is out of range: " + this.Q);
        }
    }

    private void rangeAdjust() {
        if (this.Y < 0.0f) {
            this.Y = 0.0f;
        } else if (this.Y > 1.0f) {
            this.Y = 1.0f;
        }
        if (this.I < 0.0f) {
            this.I = 0.0f;
        } else if (this.I > 1.0f) {
            this.I = 1.0f;
        }
        if (this.Q < 0.0f) {
            this.Q = 0.0f;
        } else if (this.Q > 1.0f) {
            this.Q = 1.0f;
        }
    }

    public float getY() {
        return this.Y;
    }

    public float getI() {
        return this.I;
    }

    public float getQ() {
        return this.Q;
    }

    public void setY(float f) {
        this.Y = f;
    }

    public void seti(float f) {
        this.I = f;
    }

    public void setQ(float f) {
        this.Q = f;
    }

    public ColorSRGB toSRGB() throws ColorException {
        float f = 1.0f * this.Y + 0.955653f * this.I + 0.622895f * this.Q;
        float f2 = 1.0f * this.Y - 0.27215f * this.I - 0.64834f * this.Q;
        float f3 = 1.0f * this.Y - 1.10516f * this.I + 1.704625f * this.Q;
        return new ColorSRGB(f, f2, f3, false);
    }
}

