/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPReader;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;

public class ChunkedMessageBodyReader
extends HTTPReader {
    static final Logger LOGGER = Logger.getLogger(ChunkedMessageBodyReader.class);

    public ChunkedMessageBodyReader(InputStream inputStream) {
        super(inputStream);
    }

    public int readChunkedMessage(long l, OutputStream outputStream, HTTPMessage hTTPMessage) throws IOException, TimeoutException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("readChunkedMessage: timeout=" + l);
        }
        int n = this.readChunkedMessageBody(l, outputStream);
        HTTPMessageBuffer hTTPMessageBuffer = hTTPMessage.getBuffer();
        HeaderInBuffer headerInBuffer = this.readHeader(l, hTTPMessageBuffer);
        while (headerInBuffer != null) {
            hTTPMessage.addTrailingHeader(headerInBuffer);
            headerInBuffer = this.readHeader(l, hTTPMessageBuffer);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("readChunkedMessage: totalChunkSize=" + n);
        }
        return n;
    }
}

