/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.httpproxy.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class Logger {
    private static final String COMMA_SPACE = ", ";
    private static String PROP_LOGGING_CONFIGURATION = "httpproxy.conf.logging";
    public static final String DEFAULT_LOGGING_CONFIGURATION = "logging.conf";
    private final java.util.logging.Logger fDelegate;

    public static void setConfigPropertyName(String string) {
        PROP_LOGGING_CONFIGURATION = string;
    }

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz);
    }

    public static void configure() throws Exception {
        Object object;
        String string = System.getProperty(PROP_LOGGING_CONFIGURATION, DEFAULT_LOGGING_CONFIGURATION);
        Properties properties = new Properties();
        IOException iOException = null;
        if (string != null) {
            try {
                object = new FileInputStream(string);
                LogManager.getLogManager().readConfiguration((InputStream)object);
                object = new FileInputStream(string);
                properties.load((InputStream)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                iOException = fileNotFoundException;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        object = java.util.logging.Logger.getLogger("");
        ((java.util.logging.Logger)object).setLevel(Level.ALL);
        if (iOException != null) {
            throw iOException;
        }
    }

    public static void configure(InputStream inputStream) throws Exception {
        IOException iOException = null;
        if (inputStream != null) {
            try {
                LogManager.getLogManager().readConfiguration(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                iOException = fileNotFoundException;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("");
        logger.setLevel(Level.ALL);
        if (iOException != null) {
            throw iOException;
        }
    }

    private Logger(Class clazz) {
        this.fDelegate = java.util.logging.Logger.getLogger(clazz.getName());
    }

    public final boolean isDebugEnabled() {
        return this.fDelegate.isLoggable(Level.FINE);
    }

    public final boolean isMethodTracingEnabled() {
        return this.fDelegate.isLoggable(Level.FINER);
    }

    private final String createMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void fatal(String string) {
        this.fDelegate.severe(this.createMessage(string));
    }

    public void fatal(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(COMMA_SPACE);
        stringBuffer.append(this.dumpStackTrace(throwable));
        this.fDelegate.severe(stringBuffer.toString());
    }

    public void warning(String string) {
        this.fDelegate.warning(this.createMessage(string));
    }

    public void warning(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(COMMA_SPACE);
        stringBuffer.append(this.dumpStackTrace(throwable));
        this.fDelegate.warning(stringBuffer.toString());
    }

    public void info(String string) {
        this.fDelegate.info(this.createMessage(string));
    }

    public void debug(String string) {
        this.fDelegate.fine(this.createMessage(string));
    }

    public void debug(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(COMMA_SPACE);
        stringBuffer.append(this.dumpStackTrace(throwable));
        this.fDelegate.fine(stringBuffer.toString());
    }

    private StringBuffer dumpStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer();
    }
}

