/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.tabbed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters.FSTreeNodeAdapterFactory;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class LinuxPermissionsSection
extends BaseTitledSection {
    protected IFSTreeNode node;
    protected IFSTreeNodeWorkingCopy clone;
    protected Button[] btnPermissions;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.btnPermissions = new Button[9];
        Composite comp1 = this.createPermissionGroup(null, this.composite, 0, Messages.PermissionsGroup_UserPermissions);
        Composite comp2 = this.createPermissionGroup(comp1, this.composite, 3, Messages.PermissionsGroup_GroupPermissions);
        this.createPermissionGroup(comp2, this.composite, 6, Messages.PermissionsGroup_OtherPermissions);
    }

    protected Composite createPermissionGroup(Composite prev, Composite parent, int bit, String header) {
        Composite group = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout layout = (FormLayout)group.getLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.spacing = 0;
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = prev == null ? new FormAttachment(0, 4) : new FormAttachment((Control)prev, 4);
        group.setLayoutData((Object)data);
        this.createPermissionButton(Messages.PermissionsGroup_Readable, bit, group);
        this.createPermissionButton(Messages.PermissionsGroup_Writable, bit + 1, group);
        this.createPermissionButton(Messages.PermissionsGroup_Executable, bit + 2, group);
        CLabel groupLabel = this.getWidgetFactory().createCLabel(parent, header);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)group, -5);
        data.top = new FormAttachment((Control)group, 0, 128);
        groupLabel.setLayoutData((Object)data);
        return group;
    }

    private void createPermissionButton(String label, int index, Composite parent) {
        this.btnPermissions[index] = this.getWidgetFactory().createButton(parent, label, 32);
        FormData data = new FormData();
        data.left = index % 3 == 0 ? new FormAttachment(0, 0) : new FormAttachment((Control)this.btnPermissions[index - 1], 5);
        data.right = new FormAttachment((index % 3 + 1) * 33, 0);
        data.top = index % 3 == 0 ? new FormAttachment(0, 4) : new FormAttachment((Control)this.btnPermissions[index - 1], 0, 0x1000000);
        this.btnPermissions[index].setLayoutData((Object)data);
    }

    protected void updateInput(IPeerNodeProvider input) {
        Assert.isTrue((boolean)(input instanceof FSTreeNodeAdapterFactory.FSTreeNodePeerNodeProvider));
        this.node = ((FSTreeNodeAdapterFactory.FSTreeNodePeerNodeProvider)input).getFSTreeNode();
        this.clone = this.node.createWorkingCopy();
    }

    public void refresh() {
        int i = 0;
        while (i < 9) {
            int bit = 1 << 8 - i;
            SWTControlUtil.setSelection((Button)this.btnPermissions[i], (boolean)this.clone.getPermission(bit));
            ++i;
        }
    }

    protected String getText() {
        return Messages.LinuxPermissionsSection_Permissions;
    }
}

