/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.search;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.processes.ui.search.ProcessBaseSearchable;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;

public class ProcessStateSearchable
extends ProcessBaseSearchable {
    private static final int OPTION_NOT_REMEMBER = 0;
    private static final int OPTION_SPECIFIED = 1;
    private int choice;
    private Button fBtnNotRem;
    private Button fBtnSpecified;
    private Button fBtnR;
    private Button fBtnS;
    private Button fBtnD;
    private Button fBtnZ;
    private Button fBtnT;
    private Button fBtnW;
    private boolean fIncludeR;
    private boolean fIncludeS;
    private boolean fIncludeD;
    private boolean fIncludeZ;
    private boolean fIncludeT;
    private boolean fIncludeW;
    private String fStates;

    public void createAdvancedPart(TreeViewerSearchDialog dialog, Composite parent) {
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessStateSearchable.this.optionChecked(e);
            }
        };
        Composite stateComposite = this.createGroup(parent);
        stateComposite.setLayout((Layout)new GridLayout());
        this.fBtnNotRem = new Button(stateComposite, 16);
        this.fBtnNotRem.setText(Messages.ProcessStateSearchable_NotSure);
        this.fBtnNotRem.setSelection(true);
        GridData data = new GridData();
        this.fBtnNotRem.setLayoutData((Object)data);
        this.fBtnNotRem.addSelectionListener((SelectionListener)l);
        this.fBtnSpecified = new Button(stateComposite, 16);
        this.fBtnSpecified.setText(Messages.ProcessStateSearchable_SpecifyState);
        data = new GridData();
        this.fBtnSpecified.setLayoutData((Object)data);
        this.fBtnSpecified.addSelectionListener((SelectionListener)l);
        Composite cmpStates = new Composite(stateComposite, 0);
        data = new GridData(768);
        cmpStates.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, true);
        layout.marginLeft = 20;
        cmpStates.setLayout((Layout)layout);
        this.fBtnR = new Button(cmpStates, 32);
        this.fBtnR.setText(Messages.ProcessStateSearchable_StateRunning);
        this.fBtnR.setEnabled(false);
        data = new GridData();
        this.fBtnR.setLayoutData((Object)data);
        this.fBtnR.addSelectionListener((SelectionListener)l);
        this.fBtnS = new Button(cmpStates, 32);
        this.fBtnS.setText(Messages.ProcessStateSearchable_StateSleeping);
        this.fBtnS.setEnabled(false);
        data = new GridData();
        this.fBtnS.setLayoutData((Object)data);
        this.fBtnS.addSelectionListener((SelectionListener)l);
        this.fBtnD = new Button(cmpStates, 32);
        this.fBtnD.setText(Messages.ProcessStateSearchable_StateWaiting);
        this.fBtnD.setEnabled(false);
        data = new GridData();
        this.fBtnD.setLayoutData((Object)data);
        this.fBtnD.addSelectionListener((SelectionListener)l);
        this.fBtnZ = new Button(cmpStates, 32);
        this.fBtnZ.setText(Messages.ProcessStateSearchable_StateZombie);
        this.fBtnZ.setEnabled(false);
        data = new GridData();
        this.fBtnZ.setLayoutData((Object)data);
        this.fBtnZ.addSelectionListener((SelectionListener)l);
        this.fBtnT = new Button(cmpStates, 32);
        this.fBtnT.setText(Messages.ProcessStateSearchable_StateTraced);
        this.fBtnT.setEnabled(false);
        data = new GridData();
        this.fBtnT.setLayoutData((Object)data);
        this.fBtnT.addSelectionListener((SelectionListener)l);
        this.fBtnW = new Button(cmpStates, 32);
        this.fBtnW.setText(Messages.ProcessStateSearchable_StatePaging);
        this.fBtnW.setEnabled(false);
        data = new GridData();
        this.fBtnW.setLayoutData((Object)data);
        this.fBtnW.addSelectionListener((SelectionListener)l);
    }

    @Override
    protected String getGroupTitle() {
        return Messages.ProcessStateSearchable_SectionChooseState;
    }

    public boolean isInputValid() {
        if (this.choice == 1) {
            boolean valid = this.fIncludeR || this.fIncludeS || this.fIncludeD || this.fIncludeZ || this.fIncludeT || this.fIncludeW;
            return valid;
        }
        return true;
    }

    protected void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.fBtnNotRem) {
            this.choice = 0;
            this.setButtonStates(false);
        } else if (src == this.fBtnSpecified) {
            this.choice = 1;
            this.setButtonStates(true);
            this.fStates = this.getSelectedStates();
        } else if (src == this.fBtnR) {
            this.fIncludeR = this.fBtnR.getSelection();
            this.fStates = this.getSelectedStates();
        } else if (src == this.fBtnS) {
            this.fIncludeS = this.fBtnS.getSelection();
            this.fStates = this.getSelectedStates();
        } else if (src == this.fBtnD) {
            this.fIncludeD = this.fBtnD.getSelection();
            this.fStates = this.getSelectedStates();
        } else if (src == this.fBtnZ) {
            this.fIncludeZ = this.fBtnZ.getSelection();
            this.fStates = this.getSelectedStates();
        } else if (src == this.fBtnT) {
            this.fIncludeT = this.fBtnT.getSelection();
            this.fStates = this.getSelectedStates();
        } else if (src == this.fBtnW) {
            this.fIncludeW = this.fBtnW.getSelection();
            this.fStates = this.getSelectedStates();
        }
        this.fireOptionChanged();
    }

    private String getSelectedStates() {
        StringBuilder builder = new StringBuilder();
        if (this.fIncludeR) {
            builder.append("R");
        }
        if (this.fIncludeS) {
            builder.append("S");
        }
        if (this.fIncludeD) {
            builder.append("D");
        }
        if (this.fIncludeZ) {
            builder.append("Z");
        }
        if (this.fIncludeT) {
            builder.append("T");
        }
        if (this.fIncludeW) {
            builder.append("W");
        }
        return builder.toString();
    }

    private void setButtonStates(boolean enabled) {
        this.fBtnR.setEnabled(enabled);
        this.fBtnS.setEnabled(enabled);
        this.fBtnD.setEnabled(enabled);
        this.fBtnZ.setEnabled(enabled);
        this.fBtnT.setEnabled(enabled);
        this.fBtnW.setEnabled(enabled);
    }

    public boolean match(Object element) {
        if (element instanceof IProcessContextNode) {
            switch (this.choice) {
                case 0: {
                    return true;
                }
                case 1: {
                    final IProcessContextNode node = (IProcessContextNode)element;
                    final AtomicReference<String> state = new AtomicReference<String>();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            state.set(node.getSysMonitorContext().getState());
                        }
                    };
                    Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
                    Protocol.invokeAndWait((Runnable)runnable);
                    if (state.get() == null || ((String)state.get()).length() <= 0) break;
                    state.set(((String)state.get()).toUpperCase());
                    return this.fStates.indexOf((String)state.get()) != -1;
                }
            }
        }
        return false;
    }
}

