/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.launch.ui.editor.AbstractLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.tcf.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractTcfLaunchTabContainerEditorPage
extends AbstractLaunchTabContainerEditorPage
implements ILaunchConfigurationListener {
    protected ILaunchConfigurationListener launchConfigListener = null;
    protected static final String PROP_LAUNCH_CONFIG_WC = "launchConfigWorkingCopy.transient.silent";
    protected static final String PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES = "launchConfigAttributes.transient.silent";

    public IPeerNode getPeerModel(Object input) {
        return (IPeerNode)((IAdaptable)input).getAdapter(IPeerNode.class);
    }

    private boolean isAutoSave() {
        boolean autoSave = !UIPlugin.getDefault().getPreferenceStore().getBoolean("NoLaunchEditorTabAutoSave");
        return autoSave;
    }

    public static ILaunchConfigurationWorkingCopy getLaunchConfig(IPeerNode peerNode) {
        ILaunchConfigurationWorkingCopy wc = null;
        if (peerNode != null) {
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerNode, IPropertiesAccessService.class);
            Assert.isNotNull((Object)service);
            if (service.getProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC) instanceof ILaunchConfigurationWorkingCopy) {
                wc = (ILaunchConfigurationWorkingCopy)service.getProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC);
            } else {
                wc = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().getAdapter((Object)peerNode, ILaunchConfigurationWorkingCopy.class);
                if (wc == null) {
                    wc = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().loadAdapter((Object)peerNode, "org.eclipse.debug.core.ILaunchConfigurationWorkingCopy");
                }
                Assert.isNotNull((Object)wc);
                service.setProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC, (Object)wc);
                IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate((Object)wc, String.class);
                String launchConfigAttributes = null;
                try {
                    launchConfigAttributes = delegate != null ? (String)delegate.write((Object)wc, String.class) : null;
                }
                catch (Exception exception) {}
                service.setProperty((Object)peerNode, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES, (Object)launchConfigAttributes);
            }
        }
        return wc;
    }

    public boolean setupData(Object input) {
        ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.getPeerModel(input));
        if (wc != null) {
            this.getLaunchConfigurationTab().initializeFrom((ILaunchConfiguration)wc);
            this.checkLaunchConfigDirty();
            return true;
        }
        return false;
    }

    public boolean extractData() {
        if (this.isAutoSave()) {
            return false;
        }
        ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.getPeerModel(this.getEditorInput()));
        if (wc != null && this.checkLaunchConfigDirty()) {
            this.getLaunchConfigurationTab().performApply(wc);
            try {
                IPeerNode peerNode = this.getPeerModel(this.getEditorInput());
                IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerNode, IPropertiesAccessService.class);
                Assert.isNotNull((Object)service);
                service.setProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC, null);
                wc.doSave();
                this.onPostSave((ILaunchConfiguration)wc);
                this.checkLaunchConfigDirty();
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean checkLaunchConfigDirty() {
        boolean dirty = false;
        IPeerNode peerNode = this.getPeerModel(this.getEditorInput());
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerNode, IPropertiesAccessService.class);
        String oldLaunchConfigAttributes = (String)service.getProperty((Object)peerNode, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate((Object)AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(peerNode), String.class);
        String launchConfigAttributes = null;
        try {
            launchConfigAttributes = (String)delegate.write((Object)AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(peerNode), String.class);
            dirty = !launchConfigAttributes.equals(oldLaunchConfigAttributes);
        }
        catch (Exception exception) {}
        this.setDirty(dirty);
        return dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.isAutoSave()) {
            ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.getPeerModel(this.getEditorInput()));
            if (wc != null && dirty) {
                IPeerNode peerNode = this.getPeerModel(this.getEditorInput());
                IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerNode, IPropertiesAccessService.class);
                service.setProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC, null);
                try {
                    wc.doSave();
                    this.onPostSave((ILaunchConfiguration)wc);
                }
                catch (Exception exception) {}
            }
        } else {
            super.setDirty(dirty);
            ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractTcfLaunchTabContainerEditorPage.this.getManagedForm().dirtyStateChanged();
                }
            });
        }
    }

    protected void onPostSave(ILaunchConfiguration config) {
        Assert.isNotNull((Object)config);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.launchConfigListener == null) {
            this.launchConfigListener = this;
            DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        IPeerNode peerNode = this.getPeerModel(this.getEditorInput());
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerNode, IPropertiesAccessService.class);
        service.setProperty((Object)peerNode, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES, null);
        service.setProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC, null);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        this.launchConfigListener = null;
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (!(configuration instanceof ILaunchConfigurationWorkingCopy)) {
            IPeerNode peerNode = this.getPeerModel(this.getEditorInput());
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerNode, IPropertiesAccessService.class);
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)service.getProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC);
            if (wc != null && configuration.getName().equals(wc.getName())) {
                service.setProperty((Object)peerNode, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES, null);
                service.setProperty((Object)peerNode, PROP_LAUNCH_CONFIG_WC, null);
                ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractTcfLaunchTabContainerEditorPage.this.setActive(AbstractTcfLaunchTabContainerEditorPage.this.isActive());
                    }
                });
            }
        }
    }

    protected IContributionItem doCreateLinkContribution(final IToolBarManager tbManager) {
        return new ControlContribution("SetAsDefaultContextLink"){
            IEventListener eventListener;
            {
                super($anonymous0);
                this.eventListener = null;
            }

            public void dispose() {
                super.dispose();
                if (this.eventListener == null) {
                    EventManager.getInstance().removeEventListener(this.eventListener);
                }
            }

            protected Control createControl(Composite parent) {
                final ImageHyperlink hyperlink = new ImageHyperlink(parent, 0);
                hyperlink.setText(Messages.AbstractCustomFormToolkitEditorPage_setAsDefault_link);
                hyperlink.setUnderlined(true);
                hyperlink.setForeground(AbstractTcfLaunchTabContainerEditorPage.this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
                IPeerNode defaultNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                this.setVisible(defaultNode == null || defaultNode != AbstractTcfLaunchTabContainerEditorPage.this.getEditorInputNode());
                hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).setDefaultContext((IPeerNode)AbstractTcfLaunchTabContainerEditorPage.this.getEditorInputNode());
                    }

                    public void linkEntered(HyperlinkEvent e) {
                        hyperlink.setForeground(AbstractTcfLaunchTabContainerEditorPage.this.getManagedForm().getToolkit().getHyperlinkGroup().getActiveForeground());
                    }

                    public void linkExited(HyperlinkEvent e) {
                        hyperlink.setForeground(AbstractTcfLaunchTabContainerEditorPage.this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
                    }
                });
                this.eventListener = new IEventListener(){

                    public void eventFired(EventObject event) {
                        ChangeEvent changeEvent;
                        if (event instanceof ChangeEvent && (changeEvent = (ChangeEvent)event).getSource() instanceof IDefaultContextService) {
                            IPeerNode defaultNode = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
                            this.setVisible(defaultNode == null || AbstractTcfLaunchTabContainerEditorPage.this.getEditorInputNode() == null || defaultNode != AbstractTcfLaunchTabContainerEditorPage.this.getEditorInputNode());
                            ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    tbManager.update(true);
                                }
                            });
                        }
                    }
                };
                EventManager.getInstance().addEventListener(this.eventListener, ChangeEvent.class);
                return hyperlink;
            }
        };
    }
}

