/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.swt.graphics.Image;

public class WikitextLabelProvider
extends StyledCellLabelProvider
implements ElementLabelProvider,
ILabelProvider {
    private DocmlBaseUIResources docBaseResources = DocmlBaseUIResources.INSTANCE;

    public void dispose() {
        super.dispose();
        this.docBaseResources = null;
    }

    public Image getImage(Object element) {
        if (element instanceof LtkModelElement) {
            return this.getImage((LtkModelElement)element);
        }
        if (element instanceof WikitextNameAccess) {
            return this.getImage(element);
        }
        return null;
    }

    public Image getImage(LtkModelElement element) {
        switch (element.getElementType() & 0xFFF) {
            case 1040: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
            }
            case 1057: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H1");
            }
            case 1058: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H2");
            }
            case 1059: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H3");
            }
            case 1060: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H4");
            }
            case 1061: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H5");
            }
            case 1062: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H6");
            }
            case 2048: {
                SourceStructElement foreignElement = ((EmbeddingForeignElement)element).getForeignElement();
                return foreignElement != null ? this.getEmbeddedForeignImage((LtkModelElement)foreignElement) : null;
            }
        }
        return null;
    }

    protected Image getDocBaseImage(String imageId) {
        return this.docBaseResources.getImage(imageId);
    }

    protected Image getEmbeddedForeignImage(LtkModelElement element) {
        if (element.getModelTypeId() == "Yaml") {
            return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
        }
        return null;
    }

    public Image getImage(WikitextNameAccess access) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof LtkModelElement) {
            return this.getText((LtkModelElement)element);
        }
        if (element instanceof WikitextNameAccess) {
            return this.getText(element);
        }
        return null;
    }

    public String getText(LtkModelElement element) {
        return element.getElementName().getDisplayName();
    }

    public String getText(WikitextNameAccess access) {
        return access.getDisplayName();
    }

    public StyledString getStyledText(LtkModelElement element) {
        return new StyledString(element.getElementName().getDisplayName());
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        if (cellElement instanceof LtkModelElement) {
            LtkModelElement element = (LtkModelElement)cellElement;
            cell.setImage(this.getImage(element));
            StyledString styledText = this.getStyledText(element);
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
            super.update(cell);
        } else {
            cell.setImage(null);
            cell.setText(cellElement.toString());
            cell.setStyleRanges(null);
            super.update(cell);
        }
    }
}

