/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry
implements Disposable {
    private final Map<ImageDescriptor, Image> fRegistry = new HashMap<ImageDescriptor, Image>();
    private final Display fDisplay;
    private boolean fDisposed;

    public ImageDescriptorRegistry() {
        this(UIAccess.getDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        if (display == null) {
            throw new NullPointerException("display");
        }
        this.fDisplay = display;
        this.hookDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image get(ImageDescriptor descriptor) {
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Map<ImageDescriptor, Image> map = this.fRegistry;
        synchronized (map) {
            Image result = this.fRegistry.get(descriptor);
            if (result == null && !this.fDisposed && (result = descriptor.createImage()) != null) {
                this.fRegistry.put(descriptor, result);
            }
            return result;
        }
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.fDisplay.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageDescriptorRegistry.this.dispose();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ImageDescriptor, Image> map = this.fRegistry;
        synchronized (map) {
            this.fDisposed = true;
            for (Image image : this.fRegistry.values()) {
                image.dispose();
            }
            this.fRegistry.clear();
        }
    }
}

