/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFButtonDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFButtonController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.EEFImageUtils;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFButtonLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private EEFButtonDescription description;
    private Button button;
    private IEEFButtonController controller;
    private SelectionListener selectionListener;

    public EEFButtonLifecycleManager(EEFButtonDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.button = widgetFactory.createButton(parent, "", 0);
        GridData gridData = new GridData();
        gridData.minimumWidth = 80;
        gridData.horizontalIndent = 5;
        this.button.setLayoutData((Object)gridData);
        widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createButtonController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EEFButtonLifecycleManager.this.container.isRenderingInProgress()) {
                    IStatus result = EEFButtonLifecycleManager.this.controller.pushed();
                    if (result != null && result.getSeverity() == 4) {
                        EEFIdeUiPlugin.INSTANCE.log(result);
                    } else {
                        EEFButtonLifecycleManager.this.refresh();
                    }
                }
            }
        };
        this.button.addSelectionListener(this.selectionListener);
        this.controller.onNewButtonLabel(value -> {
            if (!(this.button.isDisposed() || this.button.getText() != null && this.button.getText().equals(value))) {
                this.button.setText(Optional.ofNullable(value).orElse(""));
            }
        });
        this.controller.onNewButtonImage(value -> {
            if (!this.button.isDisposed()) {
                Optional.ofNullable(value).filter(String.class::isInstance).map(String.class::cast).flatMap(EEFImageUtils::getImage).ifPresent(arg_0 -> ((Button)this.button).setImage(arg_0));
            }
        });
    }

    @Override
    protected Control getValidationControl() {
        return this.button;
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.button.isDisposed()) {
            this.button.removeSelectionListener(this.selectionListener);
        }
        this.controller.removeNewButtonLabelConsumer();
        this.controller.removeNewButtonImageConsumer();
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.button.isDisposed()) {
            this.button.setEnabled(isEnabled);
        }
    }
}

