/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BundledImageShape implements Enumerator
{
    SQUARE_LITERAL(0, "square", "square"),
    STROKE_LITERAL(1, "stroke", "stroke"),
    TRIANGLE_LITERAL(3, "triangle", "triangle"),
    DOT_LITERAL(4, "dot", "dot"),
    RING_LITERAL(5, "ring", "ring"),
    PROVIDED_SHAPE_LITERAL(6, "providedShape", "providedShape");

    public static final int SQUARE = 0;
    public static final int STROKE = 1;
    public static final int TRIANGLE = 3;
    public static final int DOT = 4;
    public static final int RING = 5;
    public static final int PROVIDED_SHAPE = 6;
    private static final BundledImageShape[] VALUES_ARRAY;
    public static final List<BundledImageShape> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BundledImageShape[]{SQUARE_LITERAL, STROKE_LITERAL, TRIANGLE_LITERAL, DOT_LITERAL, RING_LITERAL, PROVIDED_SHAPE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BundledImageShape get(String literal) {
        BundledImageShape[] bundledImageShapeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BundledImageShape result = bundledImageShapeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BundledImageShape getByName(String name) {
        BundledImageShape[] bundledImageShapeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            BundledImageShape result = bundledImageShapeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static BundledImageShape get(int value) {
        switch (value) {
            case 0: {
                return SQUARE_LITERAL;
            }
            case 1: {
                return STROKE_LITERAL;
            }
            case 3: {
                return TRIANGLE_LITERAL;
            }
            case 4: {
                return DOT_LITERAL;
            }
            case 5: {
                return RING_LITERAL;
            }
            case 6: {
                return PROVIDED_SHAPE_LITERAL;
            }
        }
        return null;
    }

    private BundledImageShape(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

