/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.eef.properties.ui.api.EEFTabbedPropertySheetPage;
import org.eclipse.eef.properties.ui.api.IEEFSection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class EEFTabContents {
    private List<IEEFSection> sections = new ArrayList<IEEFSection>();
    private boolean controlsCreated;

    public EEFTabContents(List<IEEFSection> sections) {
        this.sections.addAll(sections);
    }

    public List<IEEFSection> getSections() {
        return this.sections;
    }

    public int getSectionIndex(IEEFSection section) {
        int i = 0;
        while (i < this.sections.size()) {
            if (section == this.sections.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IEEFSection getSectionAtIndex(int i) {
        if (i >= 0 && i < this.sections.size()) {
            return this.sections.get(i);
        }
        return null;
    }

    public void createControls(Composite parent, final EEFTabbedPropertySheetPage page) {
        Composite pageComposite = page.getWidgetFactory().createComposite(parent, 524288);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        pageComposite.setLayout((Layout)layout);
        for (final IEEFSection section : this.sections) {
            final Composite sectionComposite = page.getWidgetFactory().createComposite(pageComposite, 524288);
            sectionComposite.setLayout((Layout)new FillLayout());
            int style = 768;
            if (section.shouldUseExtraSpace()) {
                style = 1808;
            }
            GridData data = new GridData(style);
            data.heightHint = section.getMinimumHeight();
            sectionComposite.setLayoutData((Object)data);
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.createControls(sectionComposite, page);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
        this.controlsCreated = true;
    }

    public void setInput(final IWorkbenchPart part, final ISelection selection) {
        for (final IEEFSection section : this.sections) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.setInput(part, selection);
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
    }

    public void refresh() {
        for (final IEEFSection section : this.sections) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.refresh();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
    }

    public void aboutToBeShown() {
        for (final IEEFSection section : this.sections) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeShown();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
    }

    public void aboutToBeHidden() {
        for (final IEEFSection section : this.sections) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.aboutToBeHidden();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
    }

    public void dispose() {
        for (final IEEFSection section : this.sections) {
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    section.dispose();
                }
            };
            SafeRunnable.run((ISafeRunnable)runnable);
        }
    }

    public boolean controlsHaveBeenCreated() {
        return this.controlsCreated;
    }
}

