/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.danalysis.DRepresentationLocationRule;
import org.eclipse.sirius.viewpoint.DRepresentation;

public final class DRepresentationLocationRuleRegistry {
    private static final DRepresentationLocationRuleRegistry INSTANCE = new DRepresentationLocationRuleRegistry();
    private Map<DRepresentationLocationRule, Priority> repLocationRules = new HashMap<DRepresentationLocationRule, Priority>();

    private DRepresentationLocationRuleRegistry() {
    }

    public static DRepresentationLocationRuleRegistry getInstance() {
        return INSTANCE;
    }

    public void addRepLocationRule(DRepresentationLocationRule repLocationRule, Priority priority) {
        this.repLocationRules.put(repLocationRule, priority);
    }

    public void removeRepLocationRule(DRepresentationLocationRule repLocationRule) {
        this.repLocationRules.remove(repLocationRule);
    }

    public Set<DRepresentationLocationRule> getRepLocationRules() {
        return this.repLocationRules.keySet();
    }

    public void dispose() {
        this.repLocationRules.clear();
    }

    public Optional<DRepresentationLocationRule> getRepresentationLocationRule(DRepresentation representation, Resource airdResource) {
        Optional<DRepresentationLocationRule> repLocRule = this.repLocationRules.keySet().stream().filter(locRule -> locRule.providesURI(representation, airdResource)).sorted((locRule1, locRule2) -> this.repLocationRules.get(locRule2).getPriority() - this.repLocationRules.get(locRule1).getPriority()).findFirst();
        return repLocRule;
    }

    public static enum Priority {
        CORE(0),
        NORMAL(1),
        HIGH(2);

        private int priority;

        private Priority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

