/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.util;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.common.ui.tools.api.dialog.SiriusMessageDialogWithToggle;
import org.eclipse.sirius.common.ui.tools.api.util.ISaveDialogExtension;
import org.eclipse.sirius.common.ui.tools.internal.util.ISaveDialogExtensionDescriptor;
import org.eclipse.sirius.common.ui.tools.internal.util.ISaveDialogExtensionRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.PageBook;

public final class SWTUtil {
    private SWTUtil() {
    }

    public static Label createLabel(Composite parent, Image image, int style) {
        Label label = new Label(parent, style);
        label.setImage(image);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        return label;
    }

    public static Label createLabel(Composite parent, String text) {
        return SWTUtil.createLabel(parent, text, 0);
    }

    public static Label createLabel(Composite parent, Image image) {
        return SWTUtil.createLabel(parent, image, 0);
    }

    public static PageBook createPageBook(Composite parent, int style) {
        PageBook pageBook = new PageBook(parent, style);
        SWTUtil.addDisposeListener(parent, (Composite)pageBook);
        return pageBook;
    }

    public static PageBook createPageBook(Composite parent) {
        return SWTUtil.createPageBook(parent, 0);
    }

    public static FilteredTree createFilteredTree(Composite parent, int style, PatternFilter filter) {
        FilteredTree filteredTree = new FilteredTree(parent, style, filter, true);
        SWTUtil.addDisposeListener(parent, (Composite)filteredTree);
        return filteredTree;
    }

    public static Composite createCompositeHorizontalFill(Composite parent, int columns, boolean equalColumns) {
        return SWTUtil.createCompositeFill(parent, columns, equalColumns, true, false);
    }

    public static Composite createCompositeVerticalFill(Composite parent, int columns, boolean equalColumns) {
        return SWTUtil.createCompositeFill(parent, columns, equalColumns, false, true);
    }

    public static Composite createCompositeBothFill(Composite parent, int columns, boolean equalColumns) {
        return SWTUtil.createCompositeFill(parent, columns, equalColumns, true, true);
    }

    private static Composite createCompositeFill(Composite parent, int columns, boolean equalColumns, boolean horizontalFill, boolean verticalFill) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = equalColumns;
        if (horizontalFill && !verticalFill) {
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else if (!horizontalFill && verticalFill) {
            composite.setLayoutData((Object)new GridData(1, 4, false, true));
        } else if (!horizontalFill && !verticalFill) {
            composite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        } else {
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        composite.setLayout((Layout)gridLayout);
        SWTUtil.addDisposeListener(parent, composite);
        return composite;
    }

    public static Composite createComposite(Composite parent, int columns, boolean equalColumns, GridData layoutData) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = equalColumns;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)gridLayout);
        SWTUtil.addDisposeListener(parent, composite);
        return composite;
    }

    public static void addDisposeListener(Composite parent, Composite child) {
        parent.addDisposeListener((DisposeListener)new DefaultDisposeListener(child));
    }

    public static int showSaveDialog(Object objectToSave, String label, boolean canCancel) {
        return SWTUtil.showSaveDialog(objectToSave, label, canCancel, false, false);
    }

    public static int showSaveDialogWithMessage(Object objectToSave, String message, boolean canCancel) {
        return SWTUtil.showSaveDialogWithMessage(objectToSave, message, canCancel, false, false);
    }

    public static int showSaveDialog(Object objectToSave, String label, boolean canCancel, boolean stillOpenElsewhere, boolean onlyIfCustomFound) {
        String message = stillOpenElsewhere ? MessageFormat.format(Messages.SWTUtil_askToSaveChanges_openElseWhere, label) : MessageFormat.format(Messages.SWTUtil_askToSaveChanges, label);
        return SWTUtil.showSaveDialogWithMessage(objectToSave, message, canCancel, stillOpenElsewhere, onlyIfCustomFound);
    }

    public static int showSaveDialogWithMessage(final Object objectToSave, final String message, final boolean canCancel, final boolean stillOpenElsewhere, final boolean onlyIfCustomFound) {
        RunnableWithResult runnable = new RunnableWithResult(){
            private int result = 3;

            @Override
            public void run() {
                boolean customSaveDialogProvided = false;
                for (ISaveDialogExtensionDescriptor saveDialogExtensionDescriptor : ISaveDialogExtensionRegistry.getRegisteredExtensions()) {
                    ISaveDialogExtension saveDialogExtension = saveDialogExtensionDescriptor.getSaveDialogExtension();
                    if (!saveDialogExtension.isSaveDialogFor(objectToSave)) continue;
                    this.result = SWTUtil.showProvidedSaveDialog(saveDialogExtension, objectToSave, message, canCancel, stillOpenElsewhere);
                    customSaveDialogProvided = true;
                }
                if (!customSaveDialogProvided && !onlyIfCustomFound) {
                    this.result = SWTUtil.showStandardSaveDialog(message, canCancel, stillOpenElsewhere);
                }
            }

            @Override
            public int getResult() {
                return this.result;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    private static int showProvidedSaveDialog(ISaveDialogExtension saveDialogExtension, Object objectToSave, String message, boolean canCancel, boolean stillOpenElsewhere) {
        Map<String, Integer> buttons = saveDialogExtension.getButtons(stillOpenElsewhere);
        int temporaryResult = SWTUtil.openSaveDialog(message, canCancel, buttons, stillOpenElsewhere);
        return saveDialogExtension.reactToValue(objectToSave, temporaryResult, stillOpenElsewhere);
    }

    private static int showStandardSaveDialog(String label, boolean canCancel, boolean stillOpenElsewhere) {
        LinkedHashMap<String, Integer> buttons = new LinkedHashMap<String, Integer>();
        buttons.put(IDialogConstants.YES_LABEL, 2);
        buttons.put(IDialogConstants.NO_LABEL, 3);
        int temporaryResult = SWTUtil.openSaveDialog(label, canCancel, buttons, stillOpenElsewhere);
        return temporaryResult;
    }

    private static int openSaveDialog(String message, boolean canCancel, Map<String, Integer> buttons, boolean stillOpenElsewhere) {
        boolean dontPrompt;
        int choice = 0;
        IPreferenceStore platformUIPrefStore = PlatformUI.getPreferenceStore();
        boolean bl = dontPrompt = stillOpenElsewhere && !platformUIPrefStore.getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN");
        if (dontPrompt) {
            choice = 1;
        } else {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && buttons != null) {
                MessageDialog dialog = SWTUtil.createSaveDialog(message, canCancel, buttons, stillOpenElsewhere, window);
                choice = dialog.open();
                if (choice == -1) {
                    choice = 1;
                }
                switch (choice) {
                    case 2: {
                        choice = 0;
                        break;
                    }
                    case 3: {
                        choice = 1;
                        break;
                    }
                    case 1: {
                        choice = 2;
                        break;
                    }
                }
                if (stillOpenElsewhere) {
                    MessageDialogWithToggle dialogWithToggle = (MessageDialogWithToggle)dialog;
                    if (choice != 2 && dialogWithToggle.getToggleState()) {
                        platformUIPrefStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                    }
                }
            }
        }
        return choice;
    }

    private static MessageDialog createSaveDialog(String message, final boolean canCancel, Map<String, Integer> buttons, boolean stillOpenElsewhere, IWorkbenchWindow window) {
        if (canCancel) {
            buttons.put(IDialogConstants.CANCEL_LABEL, 1);
        }
        SiriusMessageDialogWithToggle dialog = new SiriusMessageDialogWithToggle(window.getShell(), Messages.SWTUtil_saveDialog_title, null, message, 3, buttons, 0, WorkbenchMessages.EditorManager_closeWithoutPromptingOption, false, stillOpenElsewhere){

            protected int getShellStyle() {
                return SWTUtil.getSaveDialogStyle(canCancel);
            }
        };
        return dialog;
    }

    private static int getSaveDialogStyle(boolean canCancel) {
        int style = canCancel ? 64 : 0;
        style = style | 0x20 | 0x800;
        style = style | 0x10000 | Window.getDefaultOrientation();
        return style;
    }

    public static int getNbLines(final String text, final int width) {
        if (text != null && text.length() > 0) {
            RunnableWithResult runnable = new RunnableWithResult(){
                int nbLines = 1;

                @Override
                public void run() {
                    Shell shell = new Shell(Display.getCurrent());
                    Label label = new Label((Composite)shell, 0);
                    this.nbLines = SWTUtil.getNbLines((Control)label, text, width);
                    label.dispose();
                    shell.dispose();
                }

                @Override
                public int getResult() {
                    return this.nbLines;
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResult();
        }
        return 1;
    }

    public static int getDefaultFontTextHeight() {
        RunnableWithResult runnable = new RunnableWithResult(){
            int height;

            @Override
            public void run() {
                Shell shell = new Shell(Display.getCurrent());
                Label label = new Label((Composite)shell, 0);
                GC gc = new GC((Drawable)label);
                this.height = gc.textExtent((String)"Some text").y;
                gc.dispose();
                label.dispose();
                shell.dispose();
            }

            @Override
            public int getResult() {
                return this.height;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    public static int getNbLines(Control control, String text, int width) {
        int nbLines = 1;
        if (text != null && text.length() > 0) {
            GC gc = new GC((Drawable)control);
            int maxExtent = gc.textExtent((String)text).x;
            nbLines = maxExtent / width;
            if (maxExtent % width > 0) {
                ++nbLines;
            }
            gc.dispose();
        }
        return nbLines;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String shortenText(String textValue, Control control, int heightOfOneLine) {
        Object result = null;
        if (textValue != null && textValue.length() > 0) {
            GC gc = new GC((Drawable)control);
            try {
                int currentWidth;
                int maxWidth = control.getParent().getBounds().width;
                int maxHeight = control.getParent().getBounds().height;
                int nbLinesAvailable = maxHeight / heightOfOneLine;
                if (nbLinesAvailable == 0) {
                    nbLinesAvailable = 1;
                }
                if ((currentWidth = gc.textExtent((String)textValue).x) / nbLinesAvailable > maxWidth) {
                    int length = textValue.length() - 4;
                    while (length > 0 && result == null) {
                        String newText = textValue.substring(0, length) + "...";
                        currentWidth = gc.textExtent((String)newText).x;
                        if (currentWidth / nbLinesAvailable < maxWidth - 1) {
                            result = newText;
                        }
                        --length;
                    }
                }
            }
            finally {
                gc.dispose();
            }
        }
        if (result != null) return result;
        return textValue;
    }

    private static class DefaultDisposeListener
    implements DisposeListener {
        private Composite composite;

        DefaultDisposeListener(Composite composite) {
            this.composite = composite;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.composite != null && !this.composite.isDisposed()) {
                this.composite.dispose();
            }
        }
    }

    private static interface RunnableWithResult
    extends Runnable {
        public int getResult();
    }
}

