/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.sirius.tests.support.api.SiriusAssert;
import org.junit.Assert;

public abstract class EqualsTestCase
extends TestCase {
    protected static final int NUM_ITERATIONS = 20;
    protected Object eq1;
    protected Object eq2;
    protected Object eq3;
    protected Object neq;

    protected abstract Object createInstance() throws Exception;

    protected abstract Object createNotEqualInstance() throws Exception;

    protected void setUp() throws Exception {
        super.setUp();
        this.eq1 = this.createInstance();
        this.eq2 = this.createInstance();
        this.eq3 = this.createInstance();
        this.neq = this.createNotEqualInstance();
        try {
            Assert.assertNotNull((String)"createInstance() returned null", (Object)this.eq1);
            Assert.assertNotNull((String)"2nd createInstance() returned null", (Object)this.eq2);
            Assert.assertNotNull((String)"3rd createInstance() returned null", (Object)this.eq3);
            Assert.assertNotNull((String)"createNotEqualInstance() returned null", (Object)this.neq);
            Assert.assertNotSame((Object)this.eq1, (Object)this.eq2);
            Assert.assertNotSame((Object)this.eq1, (Object)this.eq3);
            Assert.assertNotSame((Object)this.eq1, (Object)this.neq);
            Assert.assertNotSame((Object)this.eq2, (Object)this.eq3);
            Assert.assertNotSame((Object)this.eq2, (Object)this.neq);
            Assert.assertNotSame((Object)this.eq3, (Object)this.neq);
            Assert.assertEquals((String)"1st and 2nd equal instances of different classes", this.eq1.getClass(), this.eq2.getClass());
            Assert.assertEquals((String)"1st and 3rd equal instances of different classes", this.eq1.getClass(), this.eq3.getClass());
            Assert.assertEquals((String)"1st equal instance and not-equal instance of different classes", this.eq1.getClass(), this.neq.getClass());
        }
        catch (AssertionFailedError ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public final void testEqualsAgainstNewObject() {
        Object o = new Object();
        SiriusAssert.assertNotEquals(this.eq1, o);
        SiriusAssert.assertNotEquals(this.eq2, o);
        SiriusAssert.assertNotEquals(this.eq3, o);
        SiriusAssert.assertNotEquals(this.neq, o);
    }

    public final void testEqualsAgainstNull() {
        SiriusAssert.assertNotEquals("1st vs. null", this.eq1, null);
        SiriusAssert.assertNotEquals("2nd vs. null", this.eq2, null);
        SiriusAssert.assertNotEquals("3rd vs. null", this.eq3, null);
        SiriusAssert.assertNotEquals("not-equal vs. null", this.neq, null);
    }

    public final void testEqualsAgainstUnequalObjects() {
        SiriusAssert.assertNotEquals("1st vs. not-equal", this.eq1, this.neq);
        SiriusAssert.assertNotEquals("2nd vs. not-equal", this.eq2, this.neq);
        SiriusAssert.assertNotEquals("3rd vs. not-equal", this.eq3, this.neq);
        SiriusAssert.assertNotEquals("not-equal vs. 1st", this.neq, this.eq1);
        SiriusAssert.assertNotEquals("not-equal vs. 2nd", this.neq, this.eq2);
        SiriusAssert.assertNotEquals("not-equal vs. 3rd", this.neq, this.eq3);
    }

    public final void testEqualsIsConsistentAcrossInvocations() {
        int i = 0;
        while (i < 20) {
            this.testEqualsAgainstNewObject();
            this.testEqualsAgainstNull();
            this.testEqualsAgainstUnequalObjects();
            this.testEqualsIsReflexive();
            this.testEqualsIsSymmetricAndTransitive();
            ++i;
        }
    }

    public final void testEqualsIsReflexive() {
        Assert.assertEquals((String)"1st equal instance", (Object)this.eq1, (Object)this.eq1);
        Assert.assertEquals((String)"2nd equal instance", (Object)this.eq2, (Object)this.eq2);
        Assert.assertEquals((String)"3rd equal instance", (Object)this.eq3, (Object)this.eq3);
        Assert.assertEquals((String)"not-equal instance", (Object)this.neq, (Object)this.neq);
    }

    public final void testEqualsIsSymmetricAndTransitive() {
        Assert.assertEquals((String)"1st vs. 2nd", (Object)this.eq1, (Object)this.eq2);
        Assert.assertEquals((String)"2nd vs. 1st", (Object)this.eq2, (Object)this.eq1);
        Assert.assertEquals((String)"1st vs. 3rd", (Object)this.eq1, (Object)this.eq3);
        Assert.assertEquals((String)"3rd vs. 1st", (Object)this.eq3, (Object)this.eq1);
        Assert.assertEquals((String)"2nd vs. 3rd", (Object)this.eq2, (Object)this.eq3);
        Assert.assertEquals((String)"3rd vs. 2nd", (Object)this.eq3, (Object)this.eq2);
    }
}

