/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeAllOnlyLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class DiagramMenuUpdater
implements ISelectionListener {
    private IDiagramWorkbenchPart part;

    public DiagramMenuUpdater(IDiagramWorkbenchPart part) {
        this.part = part;
    }

    public void selectionChanged(IWorkbenchPart partSelected, ISelection selection) {
        List selectedElements;
        if (partSelected == this.part && selection instanceof IStructuredSelection && this.isRelevantSelection(selectedElements = ((IStructuredSelection)selection).toList()) && this.arrangeSelectionActionShouldBeDisable(selectedElements)) {
            this.disableArrangeSelectionActionFromDiagramMenu();
        }
    }

    private boolean isRelevantSelection(Collection<?> selectedElements) {
        return selectedElements.size() != 1 || !(selectedElements.iterator().next() instanceof DiagramEditPart);
    }

    private boolean arrangeSelectionActionShouldBeDisable(Collection<?> selectedElements) {
        RootEditPart root;
        boolean arrangeSelectionActionShouldBeDisable = false;
        IGraphicalEditPart graphicalElement = null;
        Iterator<?> iterator = selectedElements.iterator();
        while (iterator.hasNext() && graphicalElement == null) {
            Object next = iterator.next();
            if (!(next instanceof IGraphicalEditPart)) continue;
            graphicalElement = (IGraphicalEditPart)next;
            break;
        }
        if (graphicalElement != null && (root = graphicalElement.getRoot()) != null && (IGraphicalEditPart)root.getChildren().iterator().next() != null) {
            IGraphicalEditPart diagramEditPart = (IGraphicalEditPart)root.getChildren().iterator().next();
            AbstractLayoutEditPartProvider layoutNodeProvider = LayoutService.getProvider(diagramEditPart).getLayoutNodeProvider(diagramEditPart);
            arrangeSelectionActionShouldBeDisable = layoutNodeProvider instanceof ArrangeAllOnlyLayoutProvider;
        }
        return arrangeSelectionActionShouldBeDisable;
    }

    private void disableArrangeSelectionActionFromDiagramMenu() {
        IContributionItem arrangeSelectionInnerItem;
        IContributionItem arrangeSelectionItem;
        Option<IMenuManager> arrangeMenuManager = this.getArrangeMenuManager();
        if (arrangeMenuManager.some() && (arrangeSelectionItem = ((IMenuManager)arrangeMenuManager.get()).find("arrangeSelectionAction")) instanceof SubContributionItem && (arrangeSelectionInnerItem = ((SubContributionItem)arrangeSelectionItem).getInnerItem()) instanceof ActionContributionItem) {
            ((ActionContributionItem)arrangeSelectionInnerItem).getAction().setEnabled(false);
        }
    }

    private Option<IMenuManager> getArrangeMenuManager() {
        IContributionItem arrangeMenuContributionItem;
        IMenuManager diagMenuManager;
        IContributionItem arrangeMenu;
        IContributionItem diagramMenuContributionItem;
        IWorkbenchWindow window;
        Option arrangeMenuManagerOption = Options.newNone();
        MenuManager menuManager = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) instanceof WorkbenchWindow) {
            menuManager = ((WorkbenchWindow)window).getMenuManager();
        }
        if (menuManager == null) {
            return arrangeMenuManagerOption;
        }
        IContributionItem diagramMenu = menuManager.find("diagramMenu");
        if (diagramMenu instanceof SubContributionItem && (diagramMenuContributionItem = ((SubContributionItem)diagramMenu).getInnerItem()) instanceof IMenuManager && (arrangeMenu = (diagMenuManager = (IMenuManager)diagramMenuContributionItem).find("arrangeMenu")) instanceof SubContributionItem && (arrangeMenuContributionItem = ((SubContributionItem)arrangeMenu).getInnerItem()) instanceof IMenuManager) {
            arrangeMenuManagerOption = Options.newSome((Object)((IMenuManager)arrangeMenuContributionItem));
        }
        return arrangeMenuManagerOption;
    }
}

