/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.InterpretationContext;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.collect.GSetIntersection;
import org.eclipse.sirius.ext.base.collect.SetIntersection;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.internal.refresh.AbstractTableSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.DCellCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DFeatureColumnCandidate;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizer;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.tools.internal.Messages;

public class EditionTableSynchronizer
extends AbstractTableSynchronizer<EditionTableDescription, FeatureColumnMapping> {
    public EditionTableSynchronizer(EditionTableDescription description, DTableElementSynchronizer sync) {
        super(description, sync);
    }

    @Override
    protected void initRefreshMonitor(IProgressMonitor monitor) {
        monitor.beginTask(Messages.DTableSynchronizerImpl_refreshEditionTabel, 2);
    }

    @Override
    protected List<FeatureColumnMapping> getColumnMappings() {
        return ((EditionTableDescription)this.description).getOwnedColumnMappings();
    }

    @Override
    protected void refreshCells(IProgressMonitor monitor, Map<TableMapping, Collection<DTableElement>> mappingToElements) {
        for (DColumn column : this.table.getColumns()) {
            for (DCell cell : new ArrayList(column.getCells())) {
                if (cell.getLine() != null) continue;
                this.sync.removeUneededCell(cell);
            }
        }
        this.fillTableDCells((LineContainer)this.table);
    }

    private void fillTableDCells(LineContainer lContainer) {
        for (DLine line : lContainer.getLines()) {
            this.fillTableDCell(line);
            this.fillTableDCells((LineContainer)line);
        }
    }

    private void fillTableDCell(DLine line) {
        SetIntersection<DCellCandidate> status = this.createCellsStatus(line);
        this.createNewCellsInTable(status);
        this.updateExistingCellsInTable(status);
        this.removeOldCellsInTable(status);
    }

    private SetIntersection<DCellCandidate> createCellsStatus(DLine line) {
        GSetIntersection status = new GSetIntersection();
        for (DCell cell : line.getCells()) {
            status.addInOld((Object)new DCellCandidate(cell, this.ids));
        }
        for (DColumn column : this.table.getColumns()) {
            ColumnMapping mapping = column.getOriginMapping();
            Option<DCell> optionalCell = TableHelper.getCell(line, column);
            EObject target = optionalCell.some() ? ((DCell)optionalCell.get()).getTarget() : line.getTarget();
            status.addInNew((Object)new DCellCandidate(mapping, target, line, column, this.ids));
        }
        return status;
    }

    private void createNewCellsInTable(SetIntersection<DCellCandidate> status) {
        for (DCellCandidate toCreate : status.getNewElements()) {
            DCell newCell = this.createCell(toCreate.getLine(), toCreate.getColumn(), toCreate.getSemantic(), (FeatureColumnMapping)toCreate.getMapping());
            this.sync.refresh(newCell);
        }
    }

    @Override
    protected DCell createCell(DLine line, DColumn column, EObject semantic, FeatureColumnMapping mapping) {
        EObject target = line.getTarget();
        String featureParentExpression = mapping.getFeatureParentExpression();
        if (featureParentExpression != null && featureParentExpression.length() > 0) {
            target = (EObject)InterpretationContext.with((RuntimeLoggerInterpreter)this.interpreter, ctx -> {
                if (line != null) {
                    ctx.setVariable("container", (Object)line.getTarget());
                    ctx.setVariable("line", (Object)line);
                }
                if (this.table != null) {
                    ctx.setVariable("root", (Object)this.table.getTarget());
                    ctx.setVariable("table", (Object)this.table);
                }
                return this.interpreter.evaluateEObject(line.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_FeatureParentExpression());
            });
        }
        if (target == null || !this.isValidColumn(target, mapping)) {
            return null;
        }
        return super.createCell(line, column, target, mapping);
    }

    private boolean isValidColumn(EObject target, FeatureColumnMapping mapping) {
        String featureName = mapping.getFeatureName();
        return "*".equals(featureName) || this.accessor.eValid(target, featureName);
    }

    private void updateExistingCellsInTable(SetIntersection<DCellCandidate> status) {
        for (DCellCandidate toUpdate : status.getKeptElements()) {
            DCell cell = toUpdate.getOriginalElement();
            this.sync.refresh(cell);
        }
    }

    private void removeOldCellsInTable(SetIntersection<DCellCandidate> status) {
        for (DCellCandidate toRemove : status.getRemovedElements()) {
            DCell cell = toRemove.getOriginalElement();
            if (cell == null) continue;
            DLine parentLine = cell.getLine();
            DColumn parentColumn = cell.getColumn();
            if (!this.accessor.getPermissionAuthority().canEditInstance((EObject)parentColumn) || !this.accessor.getPermissionAuthority().canEditInstance((EObject)parentLine)) continue;
            parentLine.getCells().remove((Object)cell);
            if (parentColumn == null) continue;
            parentColumn.getCells().remove((Object)cell);
        }
    }

    @Override
    protected int refreshColumnMapping(FeatureColumnMapping mapping, Map<TableMapping, Collection<DTableElement>> mappingToElements, int previousCurrentIndex) {
        int currentIndex = previousCurrentIndex;
        if (this.accessor.getPermissionAuthority().canCreateIn((EObject)this.table)) {
            SetIntersection<DFeatureColumnCandidate> status = this.computeCurrentStatus(mapping);
            for (DFeatureColumnCandidate toDelete : status.getRemovedElements()) {
                if (toDelete.getOriginalElement() == null) continue;
                this.doDeleteColumn((DColumn)toDelete.getOriginalElement());
            }
            for (DFeatureColumnCandidate featureColumnCandidate : status.getAllElements()) {
                if (featureColumnCandidate.getOriginalElement() == null) {
                    DFeatureColumn newC = this.createNewColumn(featureColumnCandidate.getMapping(), featureColumnCandidate.getFeatureName());
                    this.sync.refresh(newC);
                    this.table.getColumns().add(currentIndex, (Object)newC);
                } else {
                    this.sync.refresh(featureColumnCandidate.getOriginalElement());
                    DTable parentTable = featureColumnCandidate.getOriginalElement().getTable();
                    int newPosition = -1;
                    if (parentTable.getColumns().size() < currentIndex) {
                        newPosition = parentTable.getColumns().size() - 1;
                    } else if (!featureColumnCandidate.getOriginalElement().equals(parentTable.getColumns().get(currentIndex))) {
                        newPosition = currentIndex;
                    }
                    if (newPosition != -1 && this.accessor.getPermissionAuthority().canEditInstance((EObject)parentTable)) {
                        parentTable.getColumns().move(newPosition, (Object)featureColumnCandidate.getOriginalElement());
                    }
                }
                ++currentIndex;
            }
        }
        return currentIndex;
    }

    private SetIntersection<DFeatureColumnCandidate> computeCurrentStatus(FeatureColumnMapping mapping) {
        GSetIntersection status = new GSetIntersection();
        for (DColumn column : this.table.getColumns()) {
            boolean mappingIsObsolete;
            boolean bl = mappingIsObsolete = column.getOriginMapping().eResource() == null || column.getOriginMapping().eIsProxy();
            if (!mappingIsObsolete && (column.getOriginMapping() != mapping || !(column instanceof DFeatureColumn))) continue;
            status.addInOld((Object)new DFeatureColumnCandidate((DFeatureColumn)column, this.ids));
        }
        status.addInNew((Object)new DFeatureColumnCandidate((ColumnMapping)mapping, mapping.getFeatureName(), this.ids));
        return status;
    }

    protected DFeatureColumn createNewColumn(ColumnMapping mapping, String featureName) {
        DFeatureColumn column = TableFactory.eINSTANCE.createDFeatureColumn();
        column.setOriginMapping(mapping);
        column.setFeatureName(featureName);
        return column;
    }
}

