/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.business.api.query.DTableElementStyleQuery;
import org.eclipse.sirius.table.business.api.query.StyleUpdaterQuery;
import org.eclipse.sirius.table.business.internal.color.TableStyleColorUpdater;
import org.eclipse.sirius.table.business.internal.refresh.StyleWithDefaultStatus;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DCellStyle;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundConditionalStyle;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundConditionalStyle;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.StyleUpdater;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.FixedColor;

public class DTableStyleHelper {
    private final RuntimeLoggerInterpreter interpreter;

    public DTableStyleHelper(RuntimeLoggerInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void refresh(DCell cell) {
        DCellStyle style = cell.getCurrentStyle();
        if (style == null) {
            style = TableFactory.eINSTANCE.createDCellStyle();
        }
        this.doUpdateStyle(cell, style);
        if (cell.getCurrentStyle() == null && new DTableElementStyleQuery((DTableElementStyle)style).isSet()) {
            cell.setCurrentStyle(style);
        }
    }

    private void reset(EObject target, EStructuralFeature feature) {
        if (target.eIsSet(feature)) {
            target.eUnset(feature);
        }
    }

    private void doUpdateStyle(DCell cell, DCellStyle style) {
        ColumnMapping columnMapping = null;
        StyleUpdater columnStyleUpdater = null;
        DColumn column = cell.getColumn();
        if (column != null && ((columnMapping = column.getOriginMapping()) instanceof FeatureColumnMapping || columnMapping instanceof ElementColumnMapping)) {
            columnStyleUpdater = (StyleUpdater)columnMapping;
        }
        this.doUpdateFgStyle(cell, style, columnMapping, columnStyleUpdater);
        this.doUpdateBgStyle(cell, style, columnMapping, columnStyleUpdater);
    }

    private void doUpdateFgStyle(DCell cell, DCellStyle style, ColumnMapping columnMapping, StyleUpdater columnStyleUpdater) {
        IntersectionMapping intersectionMapping = cell.getIntersectionMapping();
        StyleWithDefaultStatus bestForegroundStyle = this.getBestForegroundStyle(cell, (StyleUpdater)intersectionMapping, columnStyleUpdater);
        if (bestForegroundStyle != null) {
            ForegroundStyleDescription bestForegroundStyleDesc = (ForegroundStyleDescription)bestForegroundStyle.getStyle();
            new TableStyleColorUpdater().updateForegroundColor((DTableElementStyle)style, ((ForegroundStyleDescription)bestForegroundStyle.getStyle()).getForeGroundColor(), bestForegroundStyle.isDefaultStyle(), cell.getTarget());
            this.setStyleOrigin(cell, style, bestForegroundStyle, false);
            if (!Objects.equals(style.getLabelFormat(), bestForegroundStyleDesc.getLabelFormat())) {
                FontFormatHelper.setFontFormat((List)style.getLabelFormat(), (Collection)bestForegroundStyleDesc.getLabelFormat());
            }
            if (style.getLabelSize() != bestForegroundStyleDesc.getLabelSize()) {
                style.setLabelSize(bestForegroundStyleDesc.getLabelSize());
            }
        } else {
            this.resetStyle((DTableElementStyle)style, true);
        }
    }

    private void doUpdateBgStyle(DCell cell, DCellStyle style, ColumnMapping columnMapping, StyleUpdater columnStyleUpdater) {
        IntersectionMapping intersectionMapping = cell.getIntersectionMapping();
        StyleWithDefaultStatus bestBackgroundStyle = this.getBestBackgroundColor(cell, (StyleUpdater)intersectionMapping, columnStyleUpdater);
        if (bestBackgroundStyle != null) {
            new TableStyleColorUpdater().updateBackgroundColor((DTableElementStyle)style, ((BackgroundStyleDescription)bestBackgroundStyle.getStyle()).getBackgroundColor(), bestBackgroundStyle.isDefaultStyle(), cell.getTarget());
            this.setStyleOrigin(cell, style, bestBackgroundStyle, false);
        } else {
            this.resetStyle((DTableElementStyle)style, false);
        }
    }

    private void setStyleOrigin(DCell cell, DCellStyle style, StyleWithDefaultStatus bestStyle, boolean foreground) {
        EObject styleDescription = bestStyle.getStyle();
        ColumnMapping styleOrigin = cell.getColumn().getOriginMapping();
        if (cell.getIntersectionMapping() != null && new DCellQuery(cell).isStyleDescriptionInIntersectionMapping(styleDescription)) {
            styleOrigin = cell.getIntersectionMapping();
        }
        if (foreground) {
            if (style.getForegroundStyleOrigin() != styleOrigin) {
                style.setForegroundStyleOrigin((TableMapping)styleOrigin);
            }
        } else if (style.getBackgroundStyleOrigin() != styleOrigin) {
            style.setBackgroundStyleOrigin((TableMapping)styleOrigin);
        }
    }

    public void refresh(DLine line) {
        DTableElementStyle style = line.getCurrentStyle();
        if (style == null) {
            style = TableFactory.eINSTANCE.createDTableElementStyle();
        }
        this.doUpdateStyle(line, style);
        if (line.getCurrentStyle() == null && new DTableElementStyleQuery(style).isSet()) {
            line.setCurrentStyle(style);
        }
    }

    private void doUpdateStyle(DLine line, DTableElementStyle style) {
        TableStyleColorUpdater colorUpdater = new TableStyleColorUpdater();
        LineMapping originMapping = line.getOriginMapping();
        ColorDescription bestBackgroundColor = this.getBestBackgroundColor(line, (StyleUpdater)originMapping);
        if (bestBackgroundColor != null) {
            colorUpdater.updateBackgroundColor(style, bestBackgroundColor, new StyleUpdaterQuery((StyleUpdater)originMapping).isDefaultBackgroundColor(bestBackgroundColor), line.getTarget());
        } else {
            this.resetStyle(style, false);
        }
        ForegroundStyleDescription bestForegroundStyle = this.getBestForegroundStyle(line, (StyleUpdater)originMapping);
        if (bestForegroundStyle != null) {
            boolean defaultStyleDescription = new StyleUpdaterQuery((StyleUpdater)originMapping).isDefaultForegroundColor(bestForegroundStyle.getForeGroundColor());
            colorUpdater.updateForegroundColor(style, bestForegroundStyle.getForeGroundColor(), defaultStyleDescription, line.getTarget());
            if (!Objects.equals(style.getLabelFormat(), bestForegroundStyle.getLabelFormat())) {
                FontFormatHelper.setFontFormat((List)style.getLabelFormat(), (Collection)bestForegroundStyle.getLabelFormat());
            }
            if (style.getLabelSize() != bestForegroundStyle.getLabelSize()) {
                style.setLabelSize(bestForegroundStyle.getLabelSize());
            }
            style.setDefaultForegroundStyle(defaultStyleDescription);
        } else {
            this.resetStyle(style, true);
        }
    }

    private void resetStyle(DTableElementStyle style, boolean foreground) {
        if (foreground) {
            this.reset((EObject)style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor());
            this.reset((EObject)style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize());
            this.reset((EObject)style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultForegroundStyle());
            this.reset((EObject)style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat());
        } else {
            this.reset((EObject)style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor());
            this.reset((EObject)style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultBackgroundStyle());
        }
    }

    public void refresh(DColumn column) {
        DTableElementStyle style;
        ColumnMapping mapping = column.getOriginMapping();
        if (mapping.getInitialWidth() != 0 && column.getWidth() == 0) {
            column.setWidth(mapping.getInitialWidth());
        }
        if ((style = column.getCurrentStyle()) == null) {
            style = TableFactory.eINSTANCE.createDTableElementStyle();
        }
        this.doUpdateStyle(column, style);
        if (column.getCurrentStyle() == null && new DTableElementStyleQuery(style).isSet()) {
            column.setCurrentStyle(style);
        }
    }

    private void doUpdateStyle(DColumn column, DTableElementStyle style) {
        StyleUpdater styleUpdater = null;
        ColumnMapping originMapping = column.getOriginMapping();
        if (originMapping instanceof FeatureColumnMapping || originMapping instanceof ElementColumnMapping) {
            styleUpdater = (StyleUpdater)originMapping;
        }
        TableStyleColorUpdater colorUpdater = new TableStyleColorUpdater();
        ColorDescription bestBackgroundColor = this.getBestBackgroundColor(column, styleUpdater);
        if (bestBackgroundColor != null) {
            colorUpdater.updateBackgroundColor(style, bestBackgroundColor, new StyleUpdaterQuery(styleUpdater).isDefaultBackgroundColor(bestBackgroundColor), column.getTarget());
        } else {
            this.resetStyle(style, false);
        }
        ForegroundStyleDescription bestForegroundStyle = this.getBestForegroundStyle(column, styleUpdater);
        if (bestForegroundStyle != null) {
            boolean defaultStyleDescription = new StyleUpdaterQuery(styleUpdater).isDefaultForegroundColor(bestForegroundStyle.getForeGroundColor());
            colorUpdater.updateForegroundColor(style, bestForegroundStyle.getForeGroundColor(), defaultStyleDescription, column.getTarget());
            if (!Objects.equals(style.getLabelFormat(), bestForegroundStyle.getLabelFormat())) {
                FontFormatHelper.setFontFormat((List)style.getLabelFormat(), (Collection)bestForegroundStyle.getLabelFormat());
            }
            if (style.getLabelSize() != bestForegroundStyle.getLabelSize()) {
                style.setLabelSize(bestForegroundStyle.getLabelSize());
            }
            style.setDefaultForegroundStyle(defaultStyleDescription);
        } else {
            this.resetStyle(style, true);
        }
    }

    private StyleWithDefaultStatus getBestBackgroundColor(DCell cell, StyleUpdater cellStyleUpdater, StyleUpdater columnStyleUpdater) {
        return this.getBestColorStyle(cell, cellStyleUpdater, columnStyleUpdater, styleUpdater -> this.getApplicableBgConditionalStyle((DSemanticDecorator)cell, (StyleUpdater)styleUpdater), styleUpdater -> this.getDefaulBgStyle((StyleUpdater)styleUpdater));
    }

    private <S extends EObject> StyleWithDefaultStatus getBestColorStyle(DCell cell, StyleUpdater cellStyleUpdater, StyleUpdater columnStyleUpdater, Function<StyleUpdater, S> conditionalStyleGetter, Function<StyleUpdater, S> defaultStyleGetter) {
        boolean conditional;
        EObject descr = (EObject)conditionalStyleGetter.apply(cellStyleUpdater);
        if (descr == null) {
            descr = (EObject)conditionalStyleGetter.apply(columnStyleUpdater);
        }
        boolean bl = conditional = descr != null;
        if (descr == null) {
            descr = (EObject)defaultStyleGetter.apply(cellStyleUpdater);
        }
        if (descr == null && (descr = (EObject)defaultStyleGetter.apply(columnStyleUpdater)) instanceof FixedColor) {
            descr = null;
        }
        if (descr != null) {
            return new StyleWithDefaultStatus(descr, !conditional);
        }
        return null;
    }

    private BackgroundStyleDescription getDefaulBgStyle(StyleUpdater styleUpdater) {
        if (styleUpdater != null && styleUpdater.getDefaultBackground() != null && styleUpdater.getDefaultBackground().getBackgroundColor() != null) {
            return styleUpdater.getDefaultBackground();
        }
        return null;
    }

    private BackgroundStyleDescription getApplicableBgConditionalStyle(DSemanticDecorator element, StyleUpdater styleUpdater) {
        return this.getApplicableConditionalStyle(element, styleUpdater, StyleUpdater::getBackgroundConditionalStyle, BackgroundConditionalStyle::getStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getBackgroundConditionalStyle_PredicateExpression());
    }

    private ForegroundStyleDescription getDefaulFgStyle(StyleUpdater styleUpdater) {
        if (styleUpdater != null && styleUpdater.getDefaultForeground() != null && styleUpdater.getDefaultForeground().getForeGroundColor() != null) {
            return styleUpdater.getDefaultForeground();
        }
        return null;
    }

    private ForegroundStyleDescription getApplicableFgConditionalStyle(DTableElement element, StyleUpdater styleUpdater) {
        return this.getApplicableConditionalStyle((DSemanticDecorator)element, styleUpdater, StyleUpdater::getForegroundConditionalStyle, ForegroundConditionalStyle::getStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getForegroundConditionalStyle_PredicateExpression());
    }

    private <S extends EObject, C extends EObject> S getApplicableConditionalStyle(DSemanticDecorator element, StyleUpdater styleUpdater, Function<StyleUpdater, List<C>> conditionalsProvider, Function<C, S> styleProvider, EStructuralFeature feat) {
        EObject self = element.getTarget();
        if (self == null || styleUpdater == null) {
            return null;
        }
        EObject result = null;
        for (EObject condStyle : conditionalsProvider.apply(styleUpdater)) {
            if (styleProvider.apply(condStyle) == null || !this.interpreter.evaluateBoolean(self, condStyle, feat)) continue;
            result = (EObject)styleProvider.apply(condStyle);
            break;
        }
        return (S)result;
    }

    private ColorDescription getBestBackgroundColor(DLine line, StyleUpdater styleUpdater) {
        BackgroundStyleDescription descr = this.getApplicableBgConditionalStyle((DSemanticDecorator)line, styleUpdater);
        if (descr == null) {
            descr = this.getDefaulBgStyle(styleUpdater);
        }
        if (descr != null && descr.getBackgroundColor() != null) {
            return descr.getBackgroundColor();
        }
        return null;
    }

    private ColorDescription getBestBackgroundColor(DColumn column, StyleUpdater styleUpdater) {
        BackgroundStyleDescription descr = this.getDefaulBgStyle(styleUpdater);
        if (descr != null && styleUpdater.getDefaultBackground().getBackgroundColor() instanceof FixedColor) {
            return styleUpdater.getDefaultBackground().getBackgroundColor();
        }
        return null;
    }

    private StyleWithDefaultStatus getBestForegroundStyle(DCell cell, StyleUpdater cellStyleUpdater, StyleUpdater columnStyleUpdater) {
        return this.getBestColorStyle(cell, cellStyleUpdater, columnStyleUpdater, styleUpdater -> this.getApplicableFgConditionalStyle((DTableElement)cell, (StyleUpdater)styleUpdater), styleUpdater -> this.getDefaulFgStyle((StyleUpdater)styleUpdater));
    }

    private ForegroundStyleDescription getBestForegroundStyle(DLine line, StyleUpdater styleUpdater) {
        ForegroundStyleDescription result = this.getApplicableFgConditionalStyle((DTableElement)line, styleUpdater);
        if (result == null) {
            result = styleUpdater.getDefaultForeground();
        }
        return result;
    }

    private ForegroundStyleDescription getBestForegroundStyle(DColumn column, StyleUpdater styleUpdater) {
        ForegroundStyleDescription bestForegroundStyleDescription = null;
        if (styleUpdater.getDefaultForeground() != null && styleUpdater.getDefaultForeground().getForeGroundColor() instanceof FixedColor) {
            bestForegroundStyleDescription = styleUpdater.getDefaultForeground();
        }
        return bestForegroundStyleDescription;
    }
}

