/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.api.accessor;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtenderService;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.internal.Messages;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ModelAccessorAdapter;

public class ModelAccessorsRegistry {
    private ModelAccessor nullResourceModelAccessor;
    private ModelAccessor firstCreatedModelAccessor;

    public void setNullResourceModelAccessor(ModelAccessor nullResourceModelAccessor) {
        this.nullResourceModelAccessor = nullResourceModelAccessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModelAccessor getModelAccessor(EObject modelElement) {
        ModelAccessor result = null;
        Resource modelElementResource = null;
        if (modelElement != null) {
            modelElementResource = modelElement.eResource();
        }
        if (modelElement != null && modelElementResource != null) {
            if (modelElementResource.getResourceSet() != null) return this.getModelAccessor(modelElementResource.getResourceSet());
        }
        if (this.nullResourceModelAccessor != null) {
            return this.nullResourceModelAccessor;
        }
        if (this.firstCreatedModelAccessor == null) throw new RuntimeException(Messages.ModelAccessorsRegistry_noResourceFound);
        return this.firstCreatedModelAccessor;
    }

    public ModelAccessor getModelAccessor(ResourceSet resourceSet) {
        Optional<ModelAccessorAdapter> modelAccessorAdapter = ModelAccessorAdapter.getAdapter(resourceSet);
        if (modelAccessorAdapter.isPresent()) {
            return modelAccessorAdapter.get().getModelAccessor();
        }
        ModelAccessor newPack = ExtenderService.createModelAccessor(resourceSet);
        if (this.firstCreatedModelAccessor == null) {
            this.firstCreatedModelAccessor = newPack;
        }
        newPack.init(resourceSet);
        ModelAccessorAdapter.addAdapter(resourceSet, newPack);
        return newPack;
    }

    public void disposeModelAccessor(EObject modelElement, String airDescriptionExtension) {
        Optional<ModelAccessor> optionalModelAccesor;
        Resource modelElementResource = modelElement.eResource();
        if (modelElementResource != null && modelElementResource.getResourceSet() != null && (optionalModelAccesor = ModelAccessorAdapter.removeAdapter(modelElementResource.getResourceSet())).isPresent()) {
            if (optionalModelAccesor.get().equals(this.firstCreatedModelAccessor)) {
                this.firstCreatedModelAccessor = null;
            }
            optionalModelAccesor.get().dispose();
        }
    }

    public void dispose() {
        if (this.firstCreatedModelAccessor != null) {
            this.firstCreatedModelAccessor.dispose();
            this.firstCreatedModelAccessor = null;
        }
        if (this.nullResourceModelAccessor != null) {
            this.nullResourceModelAccessor.dispose();
            this.nullResourceModelAccessor = null;
        }
    }
}

