/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part;

import com.google.common.collect.Iterables;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part.DDiagramRootEditPart;

public final class DDiagramHelper {
    private DDiagramHelper() {
    }

    public static DDiagram findParentDDiagram(IGraphicalEditPart editPart) {
        DDiagram result = null;
        IDDiagramEditPart parentDiagram = DDiagramHelper.findParentDiagram((EditPart)editPart);
        if (parentDiagram != null && editPart.isActive()) {
            result = (DDiagram)parentDiagram.resolveDDiagram().get();
        }
        return result;
    }

    public static IDDiagramEditPart findParentDiagram(EditPart element) {
        IDDiagramEditPart result = null;
        if (element instanceof IDDiagramEditPart) {
            result = (IDDiagramEditPart)element;
        } else if (element instanceof DDiagramRootEditPart) {
            Iterable ddiagramChildren = Iterables.filter((Iterable)element.getChildren(), IDDiagramEditPart.class);
            if (!Iterables.isEmpty((Iterable)ddiagramChildren)) {
                result = (IDDiagramEditPart)ddiagramChildren.iterator().next();
            }
        } else if (element != null) {
            result = DDiagramHelper.findParentDiagram(element.getParent());
        }
        return result;
    }
}

