/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.swt.graphics.Image;

public class DropDownMenuFigure
extends Clickable {
    private static final int DEFAULT_MENU_ELEMENT_HEIGHT = 20;
    private List<IFigure> elements = new ArrayList<IFigure>();
    private RoundedRectangle subMenuFigure;
    private IFigure parent;
    private Collection<MouseMotionListener> listeners;

    public DropDownMenuFigure(ImageFigure image, IFigure parent) {
        super((IFigure)image);
        this.parent = parent;
        this.listeners = new ArrayList<MouseMotionListener>();
        ButtonModel buttonModel = this.createDefaultModel();
        buttonModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                boolean visibility = DropDownMenuFigure.this.subMenuFigure.isVisible();
                DropDownMenuFigure.this.subMenuFigure.setVisible(!visibility);
                for (IFigure elem : DropDownMenuFigure.this.elements) {
                    elem.setVisible(!visibility);
                }
            }
        });
        this.setModel(buttonModel);
    }

    public void addToMenu(IFigure entry) {
        this.elements.add(entry);
    }

    public void addToMenu(Image image, String label, Runnable runnable) {
        this.elements.add(this.createActionFigure(image, label, runnable));
    }

    private IFigure createActionFigure(Image image, String label, final Runnable runnable) {
        Label imageFigure = new Label(label, image);
        imageFigure.setFont(VisualBindingManager.getDefault().getFontFromValue(9));
        imageFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                runnable.run();
            }
        });
        return imageFigure;
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        super.addMouseMotionListener(listener);
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void updateFigure() {
        this.createSubMenuFigure();
        for (IFigure elem : this.elements) {
            Dimension d = elem.getPreferredSize();
            elem.setSize(d);
            elem.setLocation(new Point(this.getBounds().getTopLeft().x, this.parent.getBounds().getTopLeft().y + 20 + 10 + elem.getSize().height * this.elements.indexOf(elem)));
            elem.setVisible(false);
            this.parent.add(elem);
        }
        this.subMenuFigure.setSize(this.getMaxWidth(), 20 * this.elements.size());
        for (MouseMotionListener listener : this.listeners) {
            this.subMenuFigure.addMouseMotionListener(listener);
        }
        this.listeners.clear();
    }

    private void createSubMenuFigure() {
        if (this.subMenuFigure == null) {
            this.subMenuFigure = new RoundedRectangle();
            this.subMenuFigure.setCornerDimensions(new Dimension(0, 0));
            this.subMenuFigure.setLocation(new Point(this.getBounds().getTopLeft().x, this.parent.getBounds().getCopy().getTopLeft().y + 20 + 10));
            this.subMenuFigure.setVisible(false);
            this.parent.add((IFigure)this.subMenuFigure);
        }
    }

    private int getMaxWidth() {
        int maxWidth = 0;
        for (IFigure elem : this.elements) {
            if (elem.getSize().width <= maxWidth) continue;
            maxWidth = elem.getSize().width;
        }
        return maxWidth;
    }
}

