/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteImageAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteLayoutAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteStyleAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteStylePureGraphicalAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.PasteFormatMenuManager;
import org.eclipse.ui.IWorkbenchPage;

public class TabbarPasteFormatMenuManager
extends PasteFormatMenuManager {
    ArrayList<IAction> actionHistory = new ArrayList();

    public void add(IAction action) {
        super.add(action);
        if (action instanceof IDisposableAction) {
            ((IDisposableAction)action).init();
        }
    }

    protected void itemRemoved(IContributionItem item) {
        IAction action;
        if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof IDisposableAction) {
            ((IDisposableAction)action).dispose();
        }
        super.itemRemoved(item);
    }

    public void dispose() {
        this.removeAll();
        this.actionHistory = null;
        super.dispose();
    }

    protected void setDefaultAction(IAction defaultAction) {
        this.actionHistory.removeIf(candidate -> candidate.getId().equals(defaultAction.getId()));
        this.actionHistory.add(0, defaultAction);
        this.setHandler(defaultAction);
        super.setDefaultAction(defaultAction);
    }

    private void setDefaultActionWithoutRegister(IAction defaultAction) {
        this.setHandler(defaultAction);
        super.setDefaultAction(defaultAction);
    }

    private void setHandler(IAction defaultAction) {
        try {
            Method method = ActionMenuManager.MenuCreatorAction.class.getDeclaredMethod("setActionHandler", IAction.class);
            method.setAccessible(true);
            method.invoke((Object)this.action, defaultAction);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    private Stream<IAction> getActions() {
        return Arrays.stream(this.getItems()).filter(ActionContributionItem.class::isInstance).map(ActionContributionItem.class::cast).map(ActionContributionItem::getAction);
    }

    private Optional<IAction> getAction(String actionId) {
        return this.getActions().filter(candidateAction -> actionId.equals(candidateAction.getId())).findAny();
    }

    private void safeAdd(String actionId, IWorkbenchPage page) {
        if (this.getAction(actionId).isEmpty()) {
            if ("pasteStylePureGraphicalAction".equals(actionId)) {
                PasteStylePureGraphicalAction action = new PasteStylePureGraphicalAction();
                action.onChangeState(Optional.of(e -> this.update()));
                this.add((IAction)action);
            } else if ("pasteFormatAction".equals(actionId)) {
                this.add((IAction)new PasteFormatAction(page));
            } else if ("pasteStyleAction".equals(actionId)) {
                this.add((IAction)new PasteStyleAction(page));
            } else if ("pasteLayoutAction".equals(actionId)) {
                this.add((IAction)new PasteLayoutAction(page));
            } else if ("pasteImageAction".equals(actionId)) {
                PasteImageAction action = new PasteImageAction();
                action.onChangeState(Optional.of(e -> this.update()));
                this.add((IAction)action);
            } else {
                throw new IllegalArgumentException(String.format("Unexpected action id '%s'", actionId));
            }
        }
    }

    private void updateActions(IWorkbenchPage page) {
        this.safeAdd("pasteStylePureGraphicalAction", page);
        this.safeAdd("pasteFormatAction", page);
        this.safeAdd("pasteLayoutAction", page);
        this.safeAdd("pasteStyleAction", page);
        if (this.elementIsSelected(page)) {
            this.safeAdd("pasteImageAction", page);
        } else {
            this.remove("pasteImageAction");
        }
    }

    private boolean elementIsSelected(IWorkbenchPage page) {
        ISelection basicSelection = page.getSelection();
        if (basicSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)basicSelection;
            Object firstElement = selection.getFirstElement();
            return !(firstElement instanceof AbstractDDiagramEditPart);
        }
        return false;
    }

    private Stream<IAction> getMenuActionCandidate() {
        Stream<IAction> actionHistoryEnabledStream = this.actionHistory.stream().filter(action -> action.isEnabled());
        Stream<IAction> allActionEnabledStream = this.getActions().filter(action -> action.isEnabled());
        Stream<IAction> enabledActions = Stream.concat(actionHistoryEnabledStream, allActionEnabledStream);
        Stream<IAction> allActions = Stream.concat(this.actionHistory.stream(), this.getActions());
        return Stream.concat(enabledActions, allActions);
    }

    private void updateDefaultAction() {
        Optional<IAction> firstEnabledAction = this.getMenuActionCandidate().findFirst();
        firstEnabledAction.ifPresent(newDefaultAction -> this.setDefaultActionWithoutRegister((IAction)newDefaultAction));
    }

    public void setVisible(boolean visible) {
        IWorkbenchPage page;
        super.setVisible(visible);
        if (visible && (page = EclipseUIUtil.getActivePage()) != null) {
            this.updateActions(page);
            this.updateDefaultAction();
        }
    }

    public void update() {
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction aContributedAction;
            IContributionItem contributionItem = iContributionItemArray[n2];
            if (contributionItem instanceof ActionContributionItem && (aContributedAction = ((ActionContributionItem)contributionItem).getAction()) instanceof DiagramAction) {
                ((DiagramAction)aContributedAction).refresh();
            }
            ++n2;
        }
        this.updateDefaultAction();
        IAction diagramAction = this.getDefaultAction();
        if (diagramAction != null) {
            this.action.setEnabled(diagramAction.isEnabled());
        }
        super.update();
    }
}

