/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.ereferencecustomization;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.sirius.business.api.query.EClassesQuery;
import org.eclipse.sirius.business.api.query.EStructuralFeaturesQuery;
import org.eclipse.sirius.editor.properties.sections.common.AbstractComboPropertySection;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.EClassQuery;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EReferenceCustomizationValuePropertySection
extends AbstractComboPropertySection {
    @Override
    protected String getDefaultLabelText() {
        return "Value";
    }

    @Override
    protected String getLabelText() {
        String labelText = super.getLabelText() + ":";
        return labelText;
    }

    protected EReference getFeature() {
        return DescriptionPackage.eINSTANCE.getEReferenceCustomization_Value();
    }

    @Override
    protected Object getFeatureValue(int index) {
        return this.getFeatureValueAt(index);
    }

    @Override
    protected boolean isEqual(int index) {
        boolean isEqual = false;
        isEqual = this.getFeatureValueAt(index) == null ? this.eObject.eGet((EStructuralFeature)this.getFeature()) == null : this.getFeatureValueAt(index).equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
        return isEqual;
    }

    protected Object getFeatureValueAt(int index) {
        List<?> values = this.getChoiceOfValues();
        if (values.size() < index || values.size() == 0 || index == -1) {
            return null;
        }
        return values.get(index);
    }

    @Override
    protected List<?> getChoiceOfValues() {
        List values = Collections.emptyList();
        List<IItemPropertyDescriptor> propertyDescriptors = this.getDescriptors();
        for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if ((EStructuralFeature)propertyDescriptor.getFeature((Object)this.eObject) != this.getFeature()) continue;
            values = new ArrayList(propertyDescriptor.getChoiceOfValues((Object)this.eObject));
        }
        if (this.eObject instanceof EReferenceCustomization) {
            Option commonType;
            EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)this.eObject;
            if (eReferenceCustomization.isApplyOnAll()) {
                LinkedHashSet features = new LinkedHashSet();
                String referenceName = eReferenceCustomization.getReferenceName();
                EClass styleDescription = StylePackage.eINSTANCE.getStyleDescription();
                UnmodifiableIterator it = Iterators.filter((Iterator)StylePackage.eINSTANCE.eAllContents(), EClass.class);
                while (it.hasNext()) {
                    EClass metaModelEClass = (EClass)it.next();
                    if (!styleDescription.isSuperTypeOf(metaModelEClass)) continue;
                    features.addAll(new EClassQuery(metaModelEClass).getEStructuralFeatures(referenceName, new ArrayList()));
                }
                commonType = new EStructuralFeaturesQuery(new ArrayList(features)).getCommonType();
            } else {
                List appliedOnEClass = Lists.transform((List)eReferenceCustomization.getAppliedOn(), (Function)new Function<EObject, EClass>(){

                    public EClass apply(EObject eObject) {
                        return eObject.eClass();
                    }
                });
                commonType = new EClassesQuery(appliedOnEClass).getCommonTypeForReference(eReferenceCustomization.getReferenceName());
            }
            ArrayList availableValues = new ArrayList();
            if (commonType.some()) {
                for (EObject value : Iterables.filter(values, EObject.class)) {
                    if (!((EClass)commonType.get()).isSuperTypeOf(value.eClass())) continue;
                    availableValues.add(value);
                }
            }
            values = availableValues;
        }
        return values;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.combo.setToolTipText("The new value to set for the property.");
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setImage(this.getHelpIcon());
        help.setToolTipText("The new value to set for the property.");
    }
}

