/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate;

import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class CalculateGraphSize
implements ILayoutProcessor<ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Calculate Graph Size", 1.0f);
        progressMonitor.logGraph(graph, "Before");
        double minXPos = Double.MAX_VALUE;
        double minYPos = Double.MAX_VALUE;
        double maxXPos = Double.MIN_VALUE;
        double maxYPos = Double.MIN_VALUE;
        for (ElkNode node : graph.getChildren()) {
            double posX = node.getX();
            double posY = node.getY();
            double width = node.getWidth();
            double height = node.getHeight();
            ElkMargin margins = (ElkMargin)node.getProperty(CoreOptions.MARGINS);
            minXPos = Math.min(minXPos, posX - margins.left);
            minYPos = Math.min(minYPos, posY - margins.top);
            maxXPos = Math.max(maxXPos, posX + width + margins.right);
            maxYPos = Math.max(maxYPos, posY + height + margins.bottom);
        }
        ElkPadding padding = (ElkPadding)graph.getProperty(CoreOptions.PADDING);
        KVector offset = new KVector(minXPos - padding.getLeft(), minYPos - padding.getTop());
        double width = maxXPos - minXPos + padding.getHorizontal();
        double height = maxYPos - minYPos + padding.getVertical();
        if (((Boolean)graph.getProperty(RadialOptions.CENTER_ON_ROOT)).booleanValue()) {
            double additionalY;
            double additionalX;
            ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
            ElkMargin rootMargins = (ElkMargin)root.getProperty(CoreOptions.MARGINS);
            double rootX = root.getX() + root.getWidth() / 2.0 + (rootMargins.left + rootMargins.right) / 2.0 - offset.x;
            double rootY = root.getY() + root.getHeight() / 2.0 + (rootMargins.top + rootMargins.bottom) / 2.0 - offset.y;
            double dx = width - rootX;
            double dy = height - rootY;
            if (dx < width / 2.0) {
                additionalX = dx - rootX;
                width += additionalX;
                offset.x -= additionalX;
            } else {
                additionalX = rootX - dx;
                width += additionalX;
            }
            if (dy < height / 2.0) {
                additionalY = dy - rootY;
                height += additionalY;
                offset.y -= additionalY;
            } else {
                additionalY = rootY - dy;
                height += additionalY;
            }
        }
        for (ElkNode node : graph.getChildren()) {
            node.setX(node.getX() - offset.x);
            node.setY(node.getY() - offset.y);
        }
        if (!((Boolean)graph.getProperty(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE)).booleanValue()) {
            graph.setWidth(width);
            graph.setHeight(height);
        }
        graph.setProperty(CoreOptions.CHILD_AREA_WIDTH, (Object)(width - padding.getHorizontal()));
        graph.setProperty(CoreOptions.CHILD_AREA_HEIGHT, (Object)(height - padding.getVertical()));
        progressMonitor.logGraph(graph, "After");
    }
}

