/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoading;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.internal.interpreter.BundleClassLoading;

public final class ClassLoadingService {
    public static final ClassLoading DEFAULT = new BundleClassLoading();
    private static final String ID = "org.eclipse.sirius.common.classloading_override";
    private static final String CLASS_ATTRIBUTE = "class";

    private ClassLoadingService() {
    }

    public static ClassLoading getClassLoading() {
        List<ClassLoading> providedClassLoadings = EclipseUtil.getExtensionPlugins(ClassLoading.class, ID, CLASS_ATTRIBUTE);
        Iterator<ClassLoading> it = providedClassLoadings.iterator();
        ClassLoading picked = null;
        while (it.hasNext()) {
            if (picked == null) {
                picked = it.next();
                continue;
            }
            Status status = new Status(2, "org.eclipse.sirius.common", MessageFormat.format(Messages.ClassLoadingService_multipleOverridesDetected, it.next().getClass().getName()));
            DslCommonPlugin.getDefault().getLog().log((IStatus)status);
        }
        if (picked == null) {
            picked = DEFAULT;
        }
        return picked;
    }
}

