/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.options;

import org.eclipse.elk.alg.spore.OverlapRemovalLayoutProvider;
import org.eclipse.elk.alg.spore.options.SporeMetaDataProvider;
import org.eclipse.elk.alg.spore.options.StructureExtractionStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class SporeOverlapRemovalOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.sporeOverlap";
    public static final IProperty<String> UNDERLYING_LAYOUT_ALGORITHM = SporeMetaDataProvider.UNDERLYING_LAYOUT_ALGORITHM;
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(8.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 8.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)8.0);
    public static final IProperty<StructureExtractionStrategy> STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY = SporeMetaDataProvider.STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY;
    public static final IProperty<Integer> OVERLAP_REMOVAL_MAX_ITERATIONS = SporeMetaDataProvider.OVERLAP_REMOVAL_MAX_ITERATIONS;
    public static final IProperty<Boolean> OVERLAP_REMOVAL_RUN_SCANLINE = SporeMetaDataProvider.OVERLAP_REMOVAL_RUN_SCANLINE;
    private static final boolean DEBUG_MODE_DEFAULT = false;
    public static final IProperty<Boolean> DEBUG_MODE = new Property(CoreOptions.DEBUG_MODE, (Object)false);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK SPOrE Overlap Removal").description("A node overlap removal algorithm proposed by Nachmanson et al. in \"Node overlap removal by growing a tree\".").providerFactory((IFactory)new SporeOverlapFactory()).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.spore").imagePath("images/overlap-removal.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.underlyingLayoutAlgorithm", UNDERLYING_LAYOUT_ALGORITHM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)8.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.structure.structureExtractionStrategy", STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.overlapRemoval.maxIterations", OVERLAP_REMOVAL_MAX_ITERATIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.overlapRemoval.runScanline", OVERLAP_REMOVAL_RUN_SCANLINE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", (Object)false);
    }

    public static class SporeOverlapFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            OverlapRemovalLayoutProvider provider = new OverlapRemovalLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

