/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.actions.ActionFactory;

public class DTreeItemEditorFocusListener
implements FocusListener {
    AbstractDTreeEditor treeEditor;
    TextCellEditor textCellEditor;
    IAction emfCutAction;
    IAction emfCopyAction;
    IAction emfPasteAction;
    IAction standardCut;
    IAction standardCopy;
    IAction standardPaste;

    public DTreeItemEditorFocusListener(AbstractDTreeEditor treeEditor, TextCellEditor textCellEditor) {
        this.treeEditor = treeEditor;
        this.textCellEditor = textCellEditor;
        this.emfCutAction = treeEditor.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
        this.emfCopyAction = treeEditor.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId());
        this.emfPasteAction = treeEditor.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.standardCut = new StandardCutAction(textCellEditor);
        this.standardCopy = new StandardCopyAction(textCellEditor);
        this.standardPaste = new StandardPasteAction(textCellEditor);
    }

    public void focusLost(FocusEvent e) {
        this.treeEditor.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.emfCutAction);
        this.treeEditor.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.emfCopyAction);
        this.treeEditor.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.emfPasteAction);
        this.treeEditor.getActionBars().updateActionBars();
    }

    public void focusGained(FocusEvent e) {
        this.treeEditor.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.standardCut);
        this.treeEditor.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.standardCopy);
        this.treeEditor.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.standardPaste);
        this.treeEditor.getActionBars().updateActionBars();
    }

    private class StandardCopyAction
    extends Action {
        TextCellEditor textCellEditor;

        StandardCopyAction(TextCellEditor textCellEditor) {
            this.textCellEditor = textCellEditor;
        }

        public void run() {
            this.textCellEditor.performCopy();
        }
    }

    private class StandardCutAction
    extends Action {
        TextCellEditor textCellEditor;

        StandardCutAction(TextCellEditor textCellEditor) {
            this.textCellEditor = textCellEditor;
        }

        public void run() {
            this.textCellEditor.performCut();
        }
    }

    private class StandardPasteAction
    extends Action {
        TextCellEditor textCellEditor;

        StandardPasteAction(TextCellEditor textCellEditor) {
            this.textCellEditor = textCellEditor;
        }

        public void run() {
            this.textCellEditor.performPaste();
        }
    }
}

