/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils.menu;

import java.util.ArrayList;
import org.eclipse.sirius.tests.swtbot.support.utils.menu.FirstContextMenuFinder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class SWTBotContextMenu {
    private final Control control;

    public SWTBotContextMenu(SWTBotTreeItem treeItem) {
        this.control = ((TreeItem)treeItem.widget).getParent();
    }

    public SWTBotContextMenu(SWTBotTree tree) {
        this.control = (Control)tree.widget;
    }

    public SWTBotContextMenu click(final String text) {
        Matcher withMnemonic = WidgetMatcherFactory.withMnemonic((String)text);
        final Matcher matcher = WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(MenuItem.class), withMnemonic});
        final FirstContextMenuFinder menuFinder = new FirstContextMenuFinder(this.control);
        final ArrayList items = new ArrayList();
        new SWTBot().waitUntil((ICondition)new DefaultCondition(){

            public String getFailureMessage() {
                return "Could not find context menu with text: " + text;
            }

            public boolean test() throws Exception {
                items.addAll(menuFinder.findMenus(matcher));
                return !items.isEmpty();
            }
        });
        MenuItem menuItem = (MenuItem)items.get(0);
        if (!menuItem.isDisposed()) {
            new SWTBotMenu(menuItem, (SelfDescribing)matcher).click();
        }
        return this;
    }

    public boolean exist(final String text) {
        Matcher withMnemonic = WidgetMatcherFactory.withMnemonic((String)text);
        final Matcher matcher = WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(MenuItem.class), withMnemonic});
        final FirstContextMenuFinder menuFinder = new FirstContextMenuFinder(this.control);
        final ArrayList items = new ArrayList();
        try {
            new SWTBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find context menu with text: " + text;
                }

                public boolean test() throws Exception {
                    items.addAll(menuFinder.findMenus(matcher));
                    return !items.isEmpty();
                }
            });
            return true;
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }
}

