/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.view.IExpandSelectionTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class EclipseUIUtil {
    private EclipseUIUtil() {
    }

    private static IWorkbenchWindow getActiveWindow() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            RunnableWithResult.Impl<IWorkbenchWindow> getActiveWorkbenchWindowRunnable = new RunnableWithResult.Impl<IWorkbenchWindow>(){

                public void run() {
                    this.setResult(workbench.getActiveWorkbenchWindow());
                }
            };
            if (Display.getCurrent() == null) {
                workbench.getDisplay().syncExec((Runnable)getActiveWorkbenchWindowRunnable);
            } else {
                getActiveWorkbenchWindowRunnable.run();
            }
            return (IWorkbenchWindow)getActiveWorkbenchWindowRunnable.getResult();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = EclipseUIUtil.getActiveWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IViewPart showView(String viewId) {
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            try {
                return page.showView(viewId);
            }
            catch (PartInitException e) {
                SiriusTransPlugin.getPlugin().error(MessageFormat.format(Messages.EclipseUIUtil_showView_error, viewId), e);
            }
        }
        return null;
    }

    public static void hideView(String viewId) {
        IViewPart view;
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null && (view = page.findView(viewId)) != null) {
            page.hideView(view);
        }
    }

    public static IViewPart getView(String viewId) {
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            return page.findView(viewId);
        }
        return null;
    }

    public static IPerspectiveDescriptor getCurrentPerspectiveDescriptor() {
        IPerspectiveDescriptor currentPerspectiveDescriptor = null;
        IWorkbenchWindow window = EclipseUIUtil.getActiveWindow();
        if (window != null) {
            currentPerspectiveDescriptor = EclipseUIUtil.getPerspectiveDescriptor(window);
        }
        if (currentPerspectiveDescriptor == null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window2 = iWorkbenchWindowArray[n2];
                window = window2;
                if (window != null && (currentPerspectiveDescriptor = EclipseUIUtil.getPerspectiveDescriptor(window)) != null) break;
                ++n2;
            }
        }
        return currentPerspectiveDescriptor;
    }

    private static IPerspectiveDescriptor getPerspectiveDescriptor(IWorkbenchWindow window) {
        IPerspectiveDescriptor currentPerspectiveDescriptor = null;
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            currentPerspectiveDescriptor = page.getPerspective();
        }
        return currentPerspectiveDescriptor;
    }

    public static void expand(final IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            IExpandSelectionTarget target = null;
            target = part instanceof IExpandSelectionTarget ? (IExpandSelectionTarget)part : (IExpandSelectionTarget)part.getAdapter(IExpandSelectionTarget.class);
            if (target == null) continue;
            final IExpandSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    finalTarget.expand(resource);
                }
            });
        }
    }

    public static void addSelectionListener(IWorkbenchPart part, ISelectionListener listener) {
        ISelectionService selectionService;
        IWorkbenchPartSite site = part.getSite();
        if (site != null && (selectionService = (ISelectionService)site.getService(ISelectionService.class)) != null) {
            selectionService.addSelectionListener(listener);
        }
    }

    public static void removeSelectionListener(IWorkbenchPart part, ISelectionListener listener) {
        ISelectionService selectionService;
        IWorkbenchPartSite site = part.getSite();
        if (site != null && (selectionService = (ISelectionService)site.getService(ISelectionService.class)) != null) {
            selectionService.removeSelectionListener(listener);
        }
    }

    public static void displayAsyncExec(Runnable r) {
        EclipseUIUtil.getCurrentDisplay().asyncExec(r);
    }

    private static Display getCurrentDisplay() {
        Display d = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : Display.getDefault();
        return d;
    }

    public static void displaySyncExec(Runnable r) {
        EclipseUIUtil.getCurrentDisplay().syncExec(r);
    }

    public static void synchronizeWithUIThread() {
        Display d = EclipseUIUtil.getCurrentDisplay();
        while (d.readAndDispatch()) {
        }
    }
}

