/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IJobRunnable;

public class SaveSessionRunnable
implements IJobRunnable {
    protected Session session;

    public SaveSessionRunnable(Session session) {
        this.session = session;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.session != null) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
            Collection<DialectEditor> editors = uiSession.getEditors();
            if (editors.isEmpty()) {
                this.session.save(monitor);
            } else {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null) {
                    IEditorPart activeEditor = activeWorkbenchWindow.getActivePage().getActiveEditor();
                    if (editors.contains(activeEditor)) {
                        activeEditor.doSave(monitor);
                    }
                } else {
                    editors.iterator().next().doSave(monitor);
                }
            }
        }
        return Status.OK_STATUS;
    }
}

