/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.lookupcall;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.lookupcall.LookupCallNewOperation;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.s2e.ui.internal.lookupcall.LookupCallNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.ui.wizard.WizardFinishTask;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class LookupCallNewWizard
extends AbstractWizard
implements INewWizard {
    private static volatile Class<? extends LookupCallNewWizardPage> pageClass = LookupCallNewWizardPage.class;
    private LookupCallNewWizardPage m_page1;
    private WizardFinishTask<LookupCallNewOperation> m_finishTask;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = this.initNewClassWizardWithPage(LookupCallNewWizard.getPage1Class(), S2eUiUtils.getSharedPackageOfSelection((ISelection)selection));
        this.m_finishTask = new WizardFinishTask(workbench.getDisplay());
        this.m_finishTask.withOperation(LookupCallNewOperation::new).withMapper(this::mapPageToOperation).withUiAction((op, d) -> {
            IType type = (IType)op.getCreatedLookupCall().result();
            d.asyncExec(() -> S2eUiUtils.openInEditor(type, false));
        });
    }

    public WizardFinishTask<LookupCallNewOperation> getFinishTask() {
        return this.m_finishTask;
    }

    protected void mapPageToOperation(WizardFinishTask.PageToOperationMappingInput input, LookupCallNewOperation op) {
        IJavaProject testProject;
        op.setPackage(this.m_page1.getTargetPackage());
        op.setLookupCallName(this.m_page1.getIcuName());
        op.setSharedSourceFolder(input.environment().toScoutSourceFolder(this.m_page1.getSourceFolder()));
        op.setSuperType(this.m_page1.getSuperType().getFullyQualifiedName());
        op.setKeyType(this.m_page1.getKeyType().getFullyQualifiedName());
        IPackageFragmentRoot serverSourceFolder = this.m_page1.getServerSourceFolder();
        if (JdtUtils.exists((IJavaElement)serverSourceFolder)) {
            op.setServerSourceFolder(input.environment().toScoutSourceFolder(serverSourceFolder));
        }
        op.setLookupServiceSuperType(this.m_page1.getServiceImplSuperType().getFullyQualifiedName());
        if (op.getTestSourceFolder() == null) {
            IPackageFragmentRoot testSourceFolder = S2eUiUtils.getTestSourceFolder((IJavaElement)this.m_page1.getServerSourceFolder(), null, "LookupCall test");
            if (testSourceFolder != null) {
                testProject = testSourceFolder.getJavaProject();
                op.setTestSourceFolder(input.environment().toScoutSourceFolder(testSourceFolder));
            } else {
                testProject = null;
            }
        } else {
            testProject = null;
        }
        op.setServerSession((String)S2eUtils.getSession(testProject, (ScoutTier)ScoutTier.Server, (IProgressMonitor)input.progress().monitor()).map(org.eclipse.jdt.core.IType::getFullyQualifiedName).orElse(null));
    }

    public static Class<? extends LookupCallNewWizardPage> getPage1Class() {
        return pageClass;
    }

    public static void setPage1Class(Class<? extends LookupCallNewWizardPage> page1Class) {
        pageClass = page1Class;
    }
}

