/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.AbstractWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class WorkingSetManager
extends AbstractWorkingSetManager
implements IWorkingSetManager,
BundleListener {
    public static final String WORKING_SET_STATE_FILENAME = "workingsets.xml";
    private static final String KEY_WORKING_SET_MANAGER_STATE = WorkingSetManager.class.getName() + "#XMLMemento";

    public WorkingSetManager(BundleContext context) {
        super(context);
    }

    @Override
    public void addRecentWorkingSet(IWorkingSet workingSet) {
        this.internalAddRecentWorkingSet(workingSet);
        this.saveState();
    }

    @Override
    public void addWorkingSet(IWorkingSet workingSet) {
        super.addWorkingSet(workingSet);
        this.saveState();
    }

    @Override
    public void removeWorkingSet(IWorkingSet workingSet) {
        if (this.internalRemoveWorkingSet(workingSet)) {
            this.saveState();
        }
    }

    public void restoreState() {
        SettingStore settingStore = RWT.getSettingStore();
        String state = settingStore.getAttribute(KEY_WORKING_SET_MANAGER_STATE);
        if (state != null) {
            try {
                StringReader reader = new StringReader(state);
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                this.restoreWorkingSetState(memento);
                this.restoreMruList(memento);
                reader.close();
            }
            catch (WorkbenchException e) {
                this.handleInternalError((Exception)((Object)e), WorkbenchMessages.get().ProblemRestoringWorkingSetState_title, WorkbenchMessages.get().ProblemRestoringWorkingSetState_message);
            }
        }
    }

    private void saveState() {
        XMLMemento memento = XMLMemento.createWriteRoot("workingSetManager");
        this.saveWorkingSetState(memento);
        this.saveMruList(memento);
        try {
            StringWriter writer = new StringWriter();
            memento.save(writer);
            writer.close();
            SettingStore settingStore = RWT.getSettingStore();
            settingStore.setAttribute(KEY_WORKING_SET_MANAGER_STATE, writer.toString());
        }
        catch (IOException ioe) {
            WorkbenchPlugin.log(WorkbenchMessages.get().ProblemSavingWorkingSetState_title, ioe);
        }
    }

    @Override
    public void workingSetChanged(IWorkingSet changedWorkingSet, String propertyChangeId, Object oldValue) {
        this.saveState();
        super.workingSetChanged(changedWorkingSet, propertyChangeId, oldValue);
    }

    private void handleInternalError(Exception exp, String title, String message) {
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, message, (Throwable)exp);
        StatusAdapter sa = new StatusAdapter((IStatus)status);
        sa.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, title);
        StatusManager.getManager().handle(sa, 3);
    }
}

