/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.eclipse.rap.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.rap.http.servlet.internal.registration.FilterRegistration;

public class FilterChainImpl
implements FilterChain {
    private final List<FilterRegistration> matchingFilterRegistrations;
    private final EndpointRegistration<?> registration;
    private final DispatcherType dispatcherType;
    private final int filterCount;
    private int filterIndex = 0;

    public FilterChainImpl(List<FilterRegistration> matchingFilterRegistrations, EndpointRegistration<?> registration, DispatcherType dispatcherType) {
        this.matchingFilterRegistrations = matchingFilterRegistrations;
        this.dispatcherType = dispatcherType;
        this.registration = registration;
        this.filterCount = matchingFilterRegistrations.size();
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        FilterRegistration filterRegistration;
        if (this.filterIndex < this.filterCount && (filterRegistration = this.matchingFilterRegistrations.get(this.filterIndex++)).appliesTo(this)) {
            filterRegistration.doFilter((HttpServletRequest)request, (HttpServletResponse)response, this);
            return;
        }
        this.registration.service((HttpServletRequest)request, (HttpServletResponse)response);
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }
}

