/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.CssColor;
import org.eclipse.rap.rwt.internal.theme.CssDimension;
import org.eclipse.rap.rwt.internal.theme.CssValue;

public class CssBorder
implements CssValue {
    public static final CssBorder NONE = new CssBorder(0, "none", null);
    private static final String[] VALID_STYLES = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"};
    public final int width;
    public final String style;
    public final CssColor color;

    private CssBorder(int width, String style, CssColor color) {
        this.width = width;
        this.style = style;
        this.color = color;
    }

    public static CssBorder create(int width, String style, CssColor color) {
        if (width <= 0 || style == null || "none".equals(style) || "hidden".equals(style)) {
            return NONE;
        }
        return new CssBorder(width, style, color);
    }

    public static CssBorder valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        String[] parts = input.split("\\s+");
        if (input.trim().length() == 0) {
            throw new IllegalArgumentException("Empty border definition");
        }
        if (parts.length > 3) {
            throw new IllegalArgumentException("Illegal number of arguments for border");
        }
        int width = -1;
        String style = null;
        CssColor color = null;
        int i = 0;
        while (i < parts.length) {
            String parsedStyle;
            Integer parsedWidth;
            String part = parts[i];
            boolean consumed = "".equals(part);
            if (!consumed && width == -1 && (parsedWidth = CssDimension.parseLength(part)) != null) {
                if (parsedWidth < 0) {
                    throw new IllegalArgumentException("Negative width: " + part);
                }
                width = parsedWidth;
                consumed = true;
            }
            if (!consumed && style == null && (parsedStyle = CssBorder.parseStyle(part)) != null) {
                style = parsedStyle;
                consumed = true;
            }
            if (!consumed && color == null) {
                color = CssColor.valueOf(part);
                consumed = true;
            }
            if (!consumed) {
                throw new IllegalArgumentException("Illegal parameter for color: " + part);
            }
            ++i;
        }
        if (width == -1) {
            width = 1;
        }
        return CssBorder.create(width, style, color);
    }

    @Override
    public String toDefaultString() {
        if (this.width == 0) {
            return "none";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.width);
        buffer.append("px ");
        buffer.append(this.style);
        if (this.color != null) {
            buffer.append(" ");
            buffer.append(this.color.toDefaultString());
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssBorder) {
            CssBorder other = (CssBorder)object;
            return other.width == this.width && this.style.equals(other.style) && (this.color == null ? other.color == null : this.color.equals(other.color));
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result += 37 * result + this.width;
        if (this.style != null) {
            result += 37 * result + this.style.hashCode();
        }
        if (this.color != null) {
            result += 37 * result + this.color.hashCode();
        }
        return result;
    }

    public String toString() {
        return "CssBorder{ " + this.width + ", " + this.style + ", " + String.valueOf(this.color) + " }";
    }

    private static String parseStyle(String part) {
        String result = null;
        int j = 0;
        while (j < VALID_STYLES.length && result == null) {
            if (VALID_STYLES[j].equalsIgnoreCase(part)) {
                result = VALID_STYLES[j];
            }
            ++j;
        }
        return result;
    }
}

