/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RequestMessage;
import org.eclipse.rap.rwt.internal.protocol.ResponseMessage;
import org.eclipse.rap.rwt.internal.remote.MessageFilter;
import org.eclipse.rap.rwt.internal.remote.MessageFilterChain;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;

public class RWTMessageHandler
implements MessageFilter {
    private final LifeCycleFactory lifeCycleFactory;

    public RWTMessageHandler(LifeCycleFactory lifeCycleFactory) {
        this.lifeCycleFactory = lifeCycleFactory;
    }

    @Override
    public ResponseMessage handleMessage(RequestMessage request, MessageFilterChain chain) {
        ClientMessage clientMessage = new ClientMessage(request);
        ProtocolUtil.setClientMessage(clientMessage);
        RWTMessageHandler.workAroundMissingReadData(clientMessage);
        this.executeLifeCycle();
        return ContextProvider.getProtocolWriter().createMessage();
    }

    private static void workAroundMissingReadData(ClientMessage message) {
        if (ProtocolUtil.isInitialRequest(message)) {
            RemoteObjectLifeCycleAdapter.readData(message);
        }
    }

    private void executeLifeCycle() {
        try {
            this.lifeCycleFactory.getLifeCycle().execute();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

