/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.lang.reflect.Modifier;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

public class DefaultEntryPointFactory
implements EntryPointFactory {
    private final Class<? extends EntryPoint> type;

    public DefaultEntryPointFactory(Class<? extends EntryPoint> type) {
        ParamCheck.notNull(type, "type");
        DefaultEntryPointFactory.checkType(type);
        this.type = type;
    }

    @Override
    public EntryPoint create() {
        EntryPoint instance;
        try {
            instance = ClassUtil.newInstance(this.type);
        }
        catch (Exception exception) {
            String message = "Could not create entrypoint instance: " + this.type.getName();
            throw new RuntimeException(message, exception);
        }
        return instance;
    }

    private static void checkType(Class<? extends EntryPoint> type) {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Abstract class or interface given as entrypoint: " + type.getName());
        }
        if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
            throw new IllegalArgumentException("Non-static inner class given as entrypoint: " + type.getName());
        }
    }
}

