/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeOperationHandler;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

final class DateTimeLCAUtil {
    private static final String TYPE = "rwt.widgets.DateTime";
    private static final String[] ALLOWED_STYLES = new String[]{"DATE", "TIME", "CALENDAR", "SHORT", "MEDIUM", "LONG", "DROP_DOWN", "BORDER"};
    private static final String PROP_CELL_SIZE = "cellSize";
    private static final String PROP_MONTH_NAMES = "monthNames";
    private static final String PROP_WEEKDAY_NAMES = "weekdayNames";
    private static final String PROP_WEEKDAY_SHORT_NAMES = "weekdayShortNames";
    private static final String PROP_DATE_SEPARATOR = "dateSeparator";
    private static final String PROP_DATE_PATTERN = "datePattern";
    private static final String PROP_SUB_WIDGETS_BOUNDS = "subWidgetsBounds";

    private DateTimeLCAUtil() {
    }

    static void renderInitialization(DateTime dateTime) {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(dateTime, TYPE);
        remoteObject.setHandler(new DateTimeOperationHandler(dateTime));
        remoteObject.set("parent", WidgetUtil.getId(dateTime.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(dateTime, ALLOWED_STYLES)));
    }

    static void renderChanges(DateTime dateTime) {
        ControlLCAUtil.renderChanges(dateTime);
        WidgetLCAUtil.renderCustomVariant(dateTime);
        WidgetLCAUtil.renderListenSelection(dateTime);
        WidgetLCAUtil.renderListenDefaultSelection(dateTime);
    }

    static void renderCellSize(DateTime dateTime) {
        Point cellSize = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getCellSize();
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(dateTime);
        remoteObject.set(PROP_CELL_SIZE, new JsonArray().add(cellSize.x).add(cellSize.y));
    }

    static void renderMonthNames(DateTime dateTime) {
        String[] monthNames = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getMonthNames();
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(dateTime);
        remoteObject.set(PROP_MONTH_NAMES, JsonUtil.createJsonArray(monthNames));
    }

    static void renderWeekdayNames(DateTime dateTime) {
        String[] weekdayNames = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getWeekdayNames();
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(dateTime);
        remoteObject.set(PROP_WEEKDAY_NAMES, JsonUtil.createJsonArray(weekdayNames));
    }

    static void renderWeekdayShortNames(DateTime dateTime) {
        String[] weekdayShortNames = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getWeekdayShortNames();
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(dateTime);
        remoteObject.set(PROP_WEEKDAY_SHORT_NAMES, JsonUtil.createJsonArray(weekdayShortNames));
    }

    static void renderDateSeparator(DateTime dateTime) {
        String dateSeparator = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getDateSeparator();
        RemoteObjectFactory.getRemoteObject(dateTime).set(PROP_DATE_SEPARATOR, dateSeparator);
    }

    static void renderDatePattern(DateTime dateTime) {
        String datePattern = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getDatePattern();
        RemoteObjectFactory.getRemoteObject(dateTime).set(PROP_DATE_PATTERN, datePattern);
    }

    static void preserveSubWidgetsBounds(DateTime dateTime, SubWidgetBounds[] subWidgetBounds) {
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_SUB_WIDGETS_BOUNDS, subWidgetBounds);
    }

    static void renderSubWidgetsBounds(DateTime dateTime, SubWidgetBounds[] subWidgetBounds) {
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_SUB_WIDGETS_BOUNDS, subWidgetBounds)) {
            JsonArray bounds = new JsonArray();
            int i = 0;
            while (i < subWidgetBounds.length) {
                bounds.add(new JsonArray().add(subWidgetBounds[i].id).add(subWidgetBounds[i].x).add(subWidgetBounds[i].y).add(subWidgetBounds[i].width).add(subWidgetBounds[i].height));
                ++i;
            }
            RemoteObjectFactory.getRemoteObject(dateTime).set(PROP_SUB_WIDGETS_BOUNDS, bounds);
        }
    }

    static SubWidgetBounds getSubWidgetBounds(DateTime dateTime, int subWidgetId) {
        Rectangle bounds = DateTimeLCAUtil.getDateTimeAdapter(dateTime).getBounds(subWidgetId);
        return new SubWidgetBounds(subWidgetId, bounds);
    }

    private static IDateTimeAdapter getDateTimeAdapter(DateTime dateTime) {
        return dateTime.getAdapter(IDateTimeAdapter.class);
    }

    static final class SubWidgetBounds {
        public final int id;
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public SubWidgetBounds(int id, Rectangle bounds) {
            ParamCheck.notNull(bounds, "subWidgetBounds");
            this.id = id;
            this.x = bounds.x;
            this.y = bounds.y;
            this.width = bounds.width;
            this.height = bounds.height;
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof SubWidgetBounds) {
                SubWidgetBounds other = (SubWidgetBounds)obj;
                result = other.id == this.id && other.x == this.x && other.y == this.y && other.width == this.width && other.height == this.height;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "SubWidgetBounds#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

