/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme.css;

import org.eclipse.rap.rwt.internal.theme.css.ConditionalSelectorImpl;
import org.eclipse.rap.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rap.rwt.internal.theme.css.ElementSelectorImpl;
import org.eclipse.rap.rwt.internal.theme.css.NullDescendantSelector;
import org.eclipse.rap.rwt.internal.theme.css.NullElementSelector;
import org.eclipse.rap.rwt.internal.theme.css.NullSiblingSelector;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SelectorFactoryImpl
implements SelectorFactory {
    private final CssFileReader reader;

    public SelectorFactoryImpl(CssFileReader reader) {
        this.reader = reader;
    }

    @Override
    public ElementSelector createElementSelector(String namespaceURI, String tagName) throws CSSException {
        return new ElementSelectorImpl(tagName);
    }

    @Override
    public ConditionalSelector createConditionalSelector(SimpleSelector selector, Condition condition) throws CSSException {
        return new ConditionalSelectorImpl(selector, condition);
    }

    @Override
    public DescendantSelector createChildSelector(Selector parent, SimpleSelector child) throws CSSException {
        String mesg = "Child selectors not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullDescendantSelector();
    }

    @Override
    public ElementSelector createPseudoElementSelector(String namespaceURI, String pseudoName) throws CSSException {
        String mesg = "Pseudo element selectors not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullElementSelector();
    }

    @Override
    public DescendantSelector createDescendantSelector(Selector parent, SimpleSelector descendant) throws CSSException {
        String mesg = "Descendant selectors not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullDescendantSelector();
    }

    @Override
    public SiblingSelector createDirectAdjacentSelector(short nodeType, Selector child, SimpleSelector directAdjacent) throws CSSException {
        String mesg = "Sibling selectors not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullSiblingSelector();
    }

    @Override
    public SimpleSelector createRootNodeSelector() throws CSSException {
        throw new CSSException("Root node selectors not supported by CSS2");
    }

    @Override
    public CharacterDataSelector createTextNodeSelector(String data) throws CSSException {
        throw new CSSException("Text node selectors not supported by CSS2");
    }

    @Override
    public CharacterDataSelector createCDataSectionSelector(String data) throws CSSException {
        throw new CSSException("CData section selectors not supported by CSS2");
    }

    @Override
    public ProcessingInstructionSelector createProcessingInstructionSelector(String target, String data) throws CSSException {
        throw new CSSException("Processing instruction selectors not supported by CSS2");
    }

    @Override
    public CharacterDataSelector createCommentSelector(String data) throws CSSException {
        throw new CSSException("Comment selectors not supported by CSS2");
    }

    @Override
    public SimpleSelector createAnyNodeSelector() throws CSSException {
        throw new CSSException("Any-node selectors not supported by CSS2");
    }

    @Override
    public NegativeSelector createNegativeSelector(SimpleSelector selector) throws CSSException {
        throw new CSSException("Negative selectors not supported by CSS2");
    }
}

